/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.AbstractCaveType;

public class CaveTypeVolcanic
extends AbstractCaveType {
    public CaveTypeVolcanic(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        double noise = simplex.get3DNoise(gen.getWorld(), pos);
        if (noise < 0.2) {
            gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
        } else if (noise < 0.4) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateFloor(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        double noise = simplex.get3DNoise(gen.getWorld(), pos);
        if (noise < 0.2) {
            gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
        } else if (noise < 0.4) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    @Override
    public void generateCeilingAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        double noise = simplex.get3DNoise(gen.getWorld(), pos.func_177984_a());
        if (noise < 0.2) {
            gen.setCeilingAddon(pos, BlockSets.Modifier.COBBLE);
        } else {
            gen.genSpeleothem(pos, this.getSpelSize(random, depth), depth, false);
        }
        gen.setCeilingAddon(pos, BlockSets.Modifier.COBBLE);
    }

    @Override
    public void generateFloorAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        double noise = simplex.get3DNoise(gen.getWorld(), pos.func_177977_b());
        if (noise < 0.2) {
            gen.setFloorAddon(pos, BlockSets.Modifier.COBBLE);
        } else {
            gen.genSpeleothem(pos, this.getSpelSize(random, depth), depth, false);
        }
        gen.setFloorAddon(pos, BlockSets.Modifier.COBBLE);
    }

    @Override
    public void generateWall(GeneratorMethods gen, Random random, BlockPos pos, float depth, int height) {
        double noise = simplex.get3DNoise(gen.getWorld(), pos);
        if (noise < 0.2) {
            gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
        } else if (noise < 0.4) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
    }

    public void generateAdjacentWall(GeneratorMethods gen, Random random, BlockPos pos, float depth, int height) {
    }
}

