/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.AdjPos;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.AbstractCaveType;

public class CaveTypeSwamp
extends AbstractCaveType {
    public CaveTypeSwamp(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        if ((double)random.nextFloat() < 0.15) {
            gen.transformBlock(pos, BlockSets.Modifier.WATER_DRIP);
        } else {
            if (simplex.get3DNoise(gen.getWorld(), pos) < 0.1) {
                gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
            }
            if (simplex.get3DNoise(gen.getWorld(), pos) - 0.5 > (double)depth) {
                gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
            }
        }
    }

    @Override
    public void generateFloor(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        if (simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.5) < 0.2) {
            gen.setWaterPatch(pos);
        }
        if (simplex.get3DNoise(gen.getWorld(), pos) < 0.1) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
        if (simplex.get3DNoise(gen.getWorld(), pos) - 0.5 > (double)depth) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateCeilingAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        if (random.nextBoolean() && gen.setCeilingAddon(pos, BlockSets.Modifier.COBBLE)) {
            int loop;
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177974_f().func_177979_c(loop), EnumFacing.WEST);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177976_e().func_177979_c(loop), EnumFacing.EAST);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177978_c().func_177979_c(loop), EnumFacing.SOUTH);
            }
            for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                gen.GenVines(pos.func_177968_d().func_177979_c(loop), EnumFacing.NORTH);
            }
        } else {
            gen.genSpeleothem(pos, this.getSpelSize(random, depth), depth, false);
        }
    }

    @Override
    public void generateFloorAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        if (random.nextBoolean() && gen.setFloorAddon(pos, BlockSets.Modifier.COBBLE)) {
            gen.GenVines(pos.func_177974_f(), EnumFacing.WEST);
            gen.GenVines(pos.func_177976_e(), EnumFacing.EAST);
            gen.GenVines(pos.func_177978_c(), EnumFacing.SOUTH);
            gen.GenVines(pos.func_177968_d(), EnumFacing.NORTH);
        } else {
            gen.genSpeleothem(pos, this.getSpelSize(random, depth), depth, false);
        }
    }

    @Override
    public void generateWall(GeneratorMethods gen, Random random, BlockPos pos, float depth, int height) {
        if (simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.5) < 0.2) {
            gen.setWaterPatch(pos);
        }
        if (simplex.get3DNoise(gen.getWorld(), pos) < 0.1) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
        if (simplex.get3DNoise(gen.getWorld(), pos) - 0.5 > (double)depth) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateAdjacentWall(GeneratorMethods gen, Random random, AdjPos pos, float depth, int height) {
        if (simplex.get3DNoise(gen.getWorld(), pos) > (double)(depth * 2.0f)) {
            gen.GenVines(pos, pos.getFace(random));
        }
    }
}

