/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import wtf.init.WTFBlocks;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.types.CaveTypeRocky;

public class CaveTypeRockySandy
extends CaveTypeRocky {
    private final IBlockState sand;
    private final IBlockState sandstone;
    private final IBlockState slab;

    public CaveTypeRockySandy(String name, int ceilingAddonPercentChance, int floorAddonPercentChance, boolean redSand) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
        this.sand = redSand ? Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND) : Blocks.field_150354_m.func_176223_P();
        this.sandstone = redSand ? WTFBlocks.natRedSandStone.func_176223_P() : WTFBlocks.natSandStone.func_176223_P();
        this.slab = redSand ? WTFBlocks.redSandSlab.func_176223_P() : WTFBlocks.sandSlab.func_176223_P();
    }

    @Override
    public void generateFloor(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        super.generateFloor(gen, random, pos, depth);
        if (simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.2) < 0.5) {
            gen.setPatch(pos, this.slab);
        }
    }

    @Override
    public void generateWall(GeneratorMethods gen, Random random, BlockPos pos, float depth, int height) {
        if (height < 3 && simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.2) < 0.5) {
            gen.replaceBlock(pos, this.sandstone);
        }
        super.generateWall(gen, random, pos, depth, height);
    }
}

