/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.AbstractCaveType;

public class CaveTypePodzol
extends AbstractCaveType {
    IBlockState podzol = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);

    public CaveTypePodzol(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        if (simplex.get3DNoise(gen.getWorld(), pos) > 0.66) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateFloor(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        if (simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.2) < 0.33) {
            gen.replaceBlock(pos.func_177984_a(), WTFBlocks.podzolSlab.func_176223_P());
        } else if (simplex.get3DNoise(gen.getWorld(), pos) > 0.66) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateCeilingAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        gen.genSpeleothem(pos, this.getSpelSize(random, depth), depth, false);
    }

    @Override
    public void generateFloorAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        BlockBush mushroom = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.2) > 0.5 ? Blocks.field_150338_P : Blocks.field_150337_Q;
        gen.replaceBlock(pos, mushroom.func_176223_P());
    }

    @Override
    public void generateWall(GeneratorMethods gen, Random random, BlockPos pos, float depth, int height) {
        if (height < 3 && simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.2) < 0.33) {
            gen.replaceBlock(pos, this.podzol);
        }
        if (simplex.get3DNoise(gen.getWorld(), pos) > 0.66) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }
}

