/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.AbstractCaveType;

public class CaveTypeMossy
extends AbstractCaveType {
    public CaveTypeMossy(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        boolean mossy;
        boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > 0.5;
        if (mossy) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateFloor(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        boolean mossy;
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.1);
        boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > 0.5;
        if (noise < 0.33) {
            if (mossy) {
                gen.setPatch(pos, WTFBlocks.mossyDirtSlab.func_176223_P());
            } else {
                gen.setPatch(pos, WTFBlocks.dirtSlab.func_176223_P());
            }
        }
        if (mossy) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateCeilingAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        gen.genSpeleothem(pos, this.getSpelSize(random, depth), depth, false);
    }

    @Override
    public void generateFloorAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        gen.genSpeleothem(pos, this.getSpelSize(random, depth), depth, false);
    }

    @Override
    public void generateWall(GeneratorMethods gen, Random random, BlockPos pos, float depth, int height) {
        boolean mossy;
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.1);
        boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > 0.5;
        if (height < 3 && noise < 0.33) {
            gen.replaceBlock(pos, Blocks.field_150346_d.func_176223_P());
            if (mossy) {
                gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
            }
        }
        if (mossy) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }
}

