/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import wtf.blocks.BlockRoots;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.utilities.wrappers.AdjPos;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.AbstractCaveType;

public class CaveTypeLush
extends AbstractCaveType {
    final IBlockState leaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false));
    final IBlockState roots = WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.jungle));
    final IBlockState fern = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN);
    final IBlockState sapling = Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.JUNGLE);

    public CaveTypeLush(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        boolean mossy;
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.1);
        boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > 0.5;
        if (noise < 0.33) {
            gen.replaceBlock(pos, Blocks.field_150346_d.func_176223_P());
        }
        if (mossy) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateFloor(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        boolean mossy;
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.1);
        boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > 0.5;
        if (noise < 0.33) {
            gen.replaceBlock(pos, Blocks.field_150346_d.func_176223_P());
        }
        if (simplex.get3DNoiseShifted(gen.getWorld(), pos, -100) > 0.66) {
            if (mossy) {
                gen.setPatch(pos, WTFBlocks.mossyDirtSlab.func_176223_P());
            } else {
                gen.setPatch(pos, WTFBlocks.dirtSlab.func_176223_P());
            }
        }
        if (simplex.get3DNoise(gen.getWorld(), pos) > 0.75) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
        if (mossy) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateCeilingAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos.func_177984_a(), 0.1);
        if (noise < 0.33) {
            gen.replaceBlock(pos, this.roots);
        } else {
            int loop;
            gen.setCeilingAddon(pos, BlockSets.Modifier.COBBLE);
            if (random.nextBoolean()) {
                for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                    gen.GenVines(pos.func_177974_f().func_177979_c(loop), EnumFacing.WEST);
                }
            }
            if (random.nextBoolean()) {
                for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                    gen.GenVines(pos.func_177976_e().func_177979_c(loop), EnumFacing.EAST);
                }
            }
            if (random.nextBoolean()) {
                for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                    gen.GenVines(pos.func_177978_c().func_177979_c(loop), EnumFacing.SOUTH);
                }
            }
            if (random.nextBoolean()) {
                for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                    gen.GenVines(pos.func_177968_d().func_177979_c(loop), EnumFacing.NORTH);
                }
            }
        }
    }

    @Override
    public void generateFloorAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos.func_177977_b(), 0.1);
        if (noise < 0.165) {
            gen.replaceBlock(pos, this.fern);
        } else if (noise < 0.33) {
            gen.replaceBlock(pos, this.sapling);
        } else if (random.nextBoolean()) {
            gen.replaceBlock(pos, this.leaves);
            gen.replaceBlock(pos.func_177978_c(), this.leaves);
            gen.replaceBlock(pos.func_177968_d(), this.leaves);
            gen.replaceBlock(pos.func_177974_f(), this.leaves);
            gen.replaceBlock(pos.func_177976_e(), this.leaves);
            gen.replaceBlock(pos.func_177984_a(), this.leaves);
        }
    }

    @Override
    public void generateWall(GeneratorMethods gen, Random random, BlockPos pos, float depth, int height) {
        boolean mossy;
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.1);
        boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > 0.5;
        if (noise < 0.33) {
            gen.replaceBlock(pos, Blocks.field_150346_d.func_176223_P());
        }
        if (simplex.get3DNoise(gen.getWorld(), pos) > 0.75) {
            gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
        }
        if (mossy) {
            gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
        }
    }

    @Override
    public void generateAdjacentWall(GeneratorMethods gen, Random random, AdjPos pos, float depth, int height) {
        boolean mossy;
        boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > 0.5;
        if (mossy) {
            gen.GenVines(pos, pos.getFace(random));
        }
    }
}

