/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.AdjPos;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.AbstractCaveType;

public class CaveTypeJungleVolcano
extends AbstractCaveType {
    public CaveTypeJungleVolcano(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, ceilingAddonPercentChance, floorAddonPercentChance);
    }

    @Override
    public void generateCeiling(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.1);
        double n = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.33);
        if (noise > 0.66) {
            if (n > 0.75) {
                gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
            } else if (n > 0.5) {
                gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
            }
        } else {
            boolean mossy;
            boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > (double)depth;
            if (mossy) {
                gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
            }
        }
        if (simplex.get3DNoise(gen.getWorld(), pos) < 0.1) {
            gen.transformBlock(pos, BlockSets.Modifier.CRACKED);
        }
    }

    @Override
    public void generateFloor(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.1);
        double n = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.33);
        if (noise > 0.66) {
            if (n > 0.75) {
                gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
            } else if (n > 0.5) {
                gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
            }
        } else {
            boolean mossy;
            boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > (double)depth;
            if (mossy) {
                gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
            }
        }
        if (simplex.get3DNoise(gen.getWorld(), pos) < 0.1) {
            gen.transformBlock(pos, BlockSets.Modifier.CRACKED);
        }
    }

    @Override
    public void generateCeilingAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos.func_177984_a(), 0.1);
        if (noise < 0.66) {
            int loop;
            gen.setCeilingAddon(pos, BlockSets.Modifier.COBBLE);
            if (random.nextBoolean()) {
                for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                    gen.GenVines(pos.func_177974_f().func_177979_c(loop), EnumFacing.WEST);
                }
            }
            if (random.nextBoolean()) {
                for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                    gen.GenVines(pos.func_177976_e().func_177979_c(loop), EnumFacing.EAST);
                }
            }
            if (random.nextBoolean()) {
                for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                    gen.GenVines(pos.func_177978_c().func_177979_c(loop), EnumFacing.SOUTH);
                }
            }
            if (random.nextBoolean()) {
                for (loop = random.nextInt(3) + 1; loop > -1; --loop) {
                    gen.GenVines(pos.func_177968_d().func_177979_c(loop), EnumFacing.NORTH);
                }
            }
        } else {
            gen.genSpeleothem(pos, this.getSpelSize(random, depth), depth, false);
        }
    }

    @Override
    public void generateFloorAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos.func_177977_b(), 0.1);
        if (noise < 0.66) {
            if (!random.nextBoolean()) {
                gen.genSpeleothem(pos, this.getSpelSize(random, depth), depth, false);
            }
        } else {
            gen.genSpeleothem(pos, this.getSpelSize(random, depth), depth, false);
        }
    }

    @Override
    public void generateWall(GeneratorMethods gen, Random random, BlockPos pos, float depth, int height) {
        double noise = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.1);
        double n = simplex.get3DNoiseScaled(gen.getWorld(), pos, 0.33);
        if (noise > 0.66) {
            if (n > 0.75) {
                gen.transformBlock(pos, BlockSets.Modifier.COBBLE);
            } else if (n > 0.5) {
                gen.transformBlock(pos, BlockSets.Modifier.LAVA_CRUST);
            }
        } else {
            boolean mossy;
            boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > (double)depth;
            if (mossy) {
                gen.transformBlock(pos, BlockSets.Modifier.MOSSY);
            }
        }
        if (simplex.get3DNoise(gen.getWorld(), pos) < 0.1) {
            gen.transformBlock(pos, BlockSets.Modifier.CRACKED);
        }
    }

    @Override
    public void generateAdjacentWall(GeneratorMethods gen, Random random, AdjPos pos, float depth, int height) {
        boolean mossy;
        boolean bl = mossy = simplex.get3DNoise(gen.getWorld(), pos) > (double)depth;
        if (mossy) {
            gen.GenVines(pos, pos.getFace(random));
        }
    }
}

