/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves.types;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import wtf.utilities.wrappers.AdjPos;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.AbstractCaveType;
import wtf.worldgen.caves.types.nether.NetherDeadForest;
import wtf.worldgen.caves.types.nether.NetherFireForest;
import wtf.worldgen.caves.types.nether.NetherFrozen;
import wtf.worldgen.caves.types.nether.NetherMushroom;
import wtf.worldgen.caves.types.nether.NetherNormal;
import wtf.worldgen.caves.types.nether.NetherSoulDesert;

public class CaveTypeHell
extends AbstractCaveType {
    public CaveTypeHell(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        super(name, 100, 100);
    }

    @Override
    public void generateCeiling(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        this.getSubType(pos).cavetype.generateCeiling(gen, random, pos, depth);
    }

    @Override
    public void generateFloor(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        this.getSubType(pos).cavetype.generateFloor(gen, random, pos, depth);
    }

    @Override
    public void generateCeilingAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        hellBiome type = this.getSubType(pos);
        if (random.nextInt(100) < ((hellBiome)type).cavetype.ceilingaddonchance) {
            type.cavetype.generateCeilingAddons(gen, random, pos, depth);
        }
    }

    @Override
    public void generateFloorAddons(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
        hellBiome type = this.getSubType(pos);
        if (random.nextInt(100) < ((hellBiome)type).cavetype.flooraddonchance) {
            type.cavetype.generateFloorAddons(gen, random, pos, depth);
        }
    }

    @Override
    public void generateWall(GeneratorMethods gen, Random random, BlockPos pos, float depth, int height) {
        this.getSubType(pos).cavetype.generateWall(gen, random, pos, depth, height);
    }

    @Override
    public void generateAdjacentWall(GeneratorMethods gen, Random random, AdjPos pos, float depth, int height) {
        this.getSubType(pos).cavetype.generateAdjacentWall(gen, random, pos, depth, height);
    }

    public hellBiome getSubType(BlockPos pos) {
        return hellBiome.NORMAL;
    }

    public static enum hellBiome {
        NORMAL(new NetherNormal()),
        SOULDESERT(new NetherSoulDesert()),
        MUSHROOM(new NetherMushroom()),
        DEADFOREST(new NetherDeadForest()),
        FIREFOREST(new NetherFireForest()),
        FROZEN(new NetherFrozen());

        private final AbstractCaveType cavetype;

        private hellBiome(AbstractCaveType type) {
            this.cavetype = type;
        }
    }
}

