/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves;

import java.util.ArrayList;
import java.util.Random;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.caves.AbstractCaveType;
import wtf.worldgen.dungeoncaves.AbstractDungeonType;

public class CaveProfile {
    public final AbstractCaveType caveDeep;
    public final AbstractCaveType caveMid;
    public final AbstractCaveType caveShallow;
    public ArrayList<AbstractDungeonType> dungeonShallow;
    public ArrayList<AbstractDungeonType> dungeonMid;
    public ArrayList<AbstractDungeonType> dungeonDeep;

    public CaveProfile(AbstractCaveType deepType, AbstractCaveType midType, AbstractCaveType shallowType) {
        this.caveDeep = deepType;
        this.caveMid = midType;
        this.caveShallow = shallowType;
    }

    public AbstractCaveType getCave(double d) {
        if (d < 0.33) {
            return this.caveDeep;
        }
        if (d < 0.66) {
            return this.caveMid;
        }
        return this.caveShallow;
    }

    public AbstractDungeonType getDungeon(Random random, int y, int surface2) {
        float height = (float)y / (float)surface2;
        if ((double)height < 0.33) {
            if (random.nextInt(100) < this.caveDeep.dungeonPercentChance) {
                return this.dungeonDeep.get(random.nextInt(this.dungeonDeep.size()));
            }
        } else if ((double)height < 0.66) {
            if (random.nextInt(100) == this.caveMid.dungeonPercentChance) {
                return this.dungeonMid.get(random.nextInt(this.dungeonMid.size()));
            }
        } else if (random.nextInt(100) < this.caveShallow.dungeonPercentChance) {
            return this.dungeonShallow.get(random.nextInt(this.dungeonShallow.size()));
        }
        return null;
    }

    public AbstractDungeonType getDungeonForCave(GeneratorMethods gen, Random random, CaveListWrapper cave, int surface2) {
        for (int loop = 0; loop < 5; ++loop) {
            int chance;
            float height = (float)cave.getAvgFloor() / (float)surface2;
            if ((double)height < 0.33) {
                chance = random.nextInt(this.dungeonDeep.size());
                if (!this.dungeonDeep.get(chance).canGenerateAt(gen, cave)) continue;
                return this.dungeonDeep.get(chance);
            }
            if ((double)height < 0.66) {
                chance = random.nextInt(this.dungeonMid.size());
                if (!this.dungeonMid.get(chance).canGenerateAt(gen, cave)) continue;
                return this.dungeonMid.get(chance);
            }
            chance = random.nextInt(this.dungeonShallow.size());
            if (!this.dungeonShallow.get(chance).canGenerateAt(gen, cave)) continue;
            return this.dungeonShallow.get(chance);
        }
        return null;
    }
}

