/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen.caves;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import wtf.utilities.simplex.SimplexHelper;
import wtf.utilities.wrappers.AdjPos;
import wtf.worldgen.GeneratorMethods;

public abstract class AbstractCaveType {
    public int dungeonPercentChance = 5;
    public final String name;
    protected static SimplexHelper simplex = new SimplexHelper("CaveGenerator");
    public final int ceilingaddonchance;
    public final int flooraddonchance;
    public boolean genAir = false;

    public AbstractCaveType(String name, int ceilingAddonPercentChance, int floorAddonPercentChance) {
        this.name = name;
        this.ceilingaddonchance = ceilingAddonPercentChance;
        this.flooraddonchance = floorAddonPercentChance;
    }

    public abstract void generateCeiling(GeneratorMethods var1, Random var2, BlockPos var3, float var4);

    public abstract void generateFloor(GeneratorMethods var1, Random var2, BlockPos var3, float var4);

    public abstract void generateCeilingAddons(GeneratorMethods var1, Random var2, BlockPos var3, float var4);

    public abstract void generateFloorAddons(GeneratorMethods var1, Random var2, BlockPos var3, float var4);

    public abstract void generateWall(GeneratorMethods var1, Random var2, BlockPos var3, float var4, int var5);

    public void generateAdjacentWall(GeneratorMethods gen, Random random, AdjPos pos, float depth, int height) {
    }

    public void generateAir(GeneratorMethods gen, Random random, BlockPos pos, float depth) {
    }

    protected int getSpelSize(Random random, float depth) {
        return (int)(Math.sqrt(random.nextInt(9)) * (double)(1.0f - depth)) + random.nextInt(2) + random.nextInt(2);
    }
}

