/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.AdjPos;
import wtf.utilities.wrappers.CavePosition;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.UnsortedChunkCaves;
import wtf.worldgen.replacers.Replacer;

public class WorldScanner {
    public HashSet<BlockPos> airBlocks = new HashSet();

    public ChunkScan getChunkScan(World world, ChunkCoords coords, GeneratorMethods gen) {
        UnsortedChunkCaves unsortedcavepos = new UnsortedChunkCaves(coords);
        ArrayList<BlockPos> water = new ArrayList<BlockPos>();
        SurfacePos[][] surfacepositions = new SurfacePos[16][16];
        Chunk chunk = coords.getChunk(world);
        ArrayList<ExtendedBlockStorage> storageList = this.getStorageList(chunk);
        int surfaceaverage = 0;
        HashMap<Integer, Boolean> xArray = new HashMap<Integer, Boolean>();
        for (int xloop = 0; xloop < 16; ++xloop) {
            HashMap<Integer, Boolean> zArray = new HashMap<Integer, Boolean>();
            int worldx = coords.getWorldX() + xloop;
            for (int zloop1 = 0; zloop1 < 16; ++zloop1) {
                boolean zig;
                int zloop;
                if ((xloop & 1) == 0) {
                    zloop = zloop1;
                    zig = true;
                } else {
                    zloop = 15 - zloop1;
                    zig = false;
                }
                int worldz = coords.getWorldZ() + zloop;
                boolean generated = false;
                boolean liquid = false;
                ArrayList<IBlockState> column = this.getColumn(storageList, xloop, zloop);
                int y = column.size() - 1;
                while (this.isAirAndCheck(chunk, gen, column.get(y), worldx, y, worldz)) {
                    --y;
                }
                while (BlockSets.liquidBlockSet.contains(column.get(y))) {
                    --y;
                    liquid = true;
                }
                while (!this.isSurfaceAndCheck(chunk, gen, column.get(y), worldx, y, worldz) && y > 1) {
                    generated = true;
                    --y;
                }
                surfacepositions[xloop][zloop] = new SurfacePos(worldx, y, worldz);
                if (generated) {
                    surfacepositions[xloop][zloop].setGenerated();
                }
                if (liquid) {
                    water.add(surfacepositions[xloop][zloop]);
                }
                surfaceaverage += y;
                int ceiling = -1;
                ArrayList<AdjPos> tempAdj = null;
                ArrayList<BlockPos> tempWall = null;
                --y;
                while (y > -1) {
                    BlockPos currentPos = new BlockPos(worldx, y, worldz);
                    BlockPos prevZpos = zig ? new BlockPos(worldx, y, worldz - 1) : new BlockPos(worldx, y, worldz + 1);
                    EnumFacing prevFaceZ = zig ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    EnumFacing nextFaceZ = zig ? EnumFacing.SOUTH : EnumFacing.NORTH;
                    boolean isAir = this.isAirAndCheck(chunk, gen, column.get(y), worldx, y, worldz);
                    if (isAir) {
                        this.airBlocks.add(currentPos);
                        if (ceiling == -1) {
                            ceiling = y + 1;
                            tempAdj = new ArrayList<AdjPos>();
                            tempWall = new ArrayList<BlockPos>();
                        }
                    }
                    if (!xArray.containsKey(zloop * 256 + y)) {
                        xArray.put(zloop * 256 + y, isAir);
                        if (isAir && !this.getIsAir(world, currentPos.func_177976_e()) && this.isWall(world, currentPos.func_177976_e())) {
                            tempWall.add(currentPos.func_177976_e());
                            tempAdj.add(new AdjPos(currentPos, EnumFacing.WEST));
                        }
                    } else if (isAir != (Boolean)xArray.get(zloop * 256 + y)) {
                        xArray.put(zloop * 256 + y, isAir);
                        if (isAir) {
                            if (this.isWall(chunk, currentPos.func_177976_e())) {
                                tempAdj.add(new AdjPos(currentPos, EnumFacing.WEST));
                                tempWall.add(currentPos.func_177976_e());
                            }
                        } else if (this.isWall(chunk, currentPos) && this.airBlocks.contains(currentPos.func_177976_e())) {
                            unsortedcavepos.addWallPos(currentPos, new AdjPos(currentPos.func_177976_e(), EnumFacing.EAST));
                        }
                    }
                    if (xloop == 15 && isAir && !this.getIsAir(world, currentPos.func_177974_f()) && this.isWall(world, currentPos.func_177974_f())) {
                        tempAdj.add(new AdjPos(currentPos, EnumFacing.EAST));
                        tempWall.add(currentPos.func_177974_f());
                    }
                    if (!zArray.containsKey(y)) {
                        zArray.put(y, this.getIsAir(world, prevZpos));
                        if (isAir && !this.getIsAir(world, prevZpos) && this.isWall(world, prevZpos)) {
                            tempWall.add(prevZpos);
                            tempAdj.add(new AdjPos(currentPos, prevFaceZ));
                        }
                    } else if (isAir != (Boolean)zArray.get(y)) {
                        zArray.put(y, isAir);
                        if (isAir) {
                            if (this.isWall(chunk, prevZpos)) {
                                tempWall.add(prevZpos);
                                tempAdj.add(new AdjPos(currentPos, prevFaceZ));
                            }
                        } else if (!(this.airBlocks.contains(prevZpos) && this.isWall(chunk, currentPos) && unsortedcavepos.addWallPos(currentPos, new AdjPos(prevZpos, nextFaceZ)))) {
                            // empty if block
                        }
                    }
                    if (zloop1 == 15 && isAir && !this.getIsAir(world, currentPos.func_177968_d()) && this.isWall(world, currentPos.func_177968_d())) {
                        tempWall.add(currentPos.func_177968_d());
                        tempAdj.add(new AdjPos(currentPos, EnumFacing.SOUTH));
                    }
                    if (!(ceiling == -1 || isAir && y != 2)) {
                        CavePosition pos = new CavePosition(worldx, ceiling, y, worldz);
                        pos.adj.addAll(tempAdj);
                        pos.wall.addAll(tempWall);
                        unsortedcavepos.add(pos);
                        tempWall = null;
                        tempAdj = null;
                        ceiling = -1;
                    }
                    --y;
                }
            }
        }
        unsortedcavepos.getSortedCaves();
        return new ChunkScan(world, coords, gen, surfacepositions, surfaceaverage /= 256, unsortedcavepos, water);
    }

    public boolean isAirAndCheck(Chunk chunk, GeneratorMethods gen, IBlockState state, int x, int y, int z) {
        Block block = state.func_177230_c();
        Replacer replacer = BlockSets.isNonSolidAndCheckReplacement.get(block);
        if (replacer != null) {
            return replacer.isNonSolidAndReplacement(chunk, new BlockPos(x, y, z), gen, state);
        }
        return false;
    }

    public boolean isWall(Chunk chunk, BlockPos pos) {
        return !this.airBlocks.contains(pos) && !this.getIsAir(chunk, pos.func_177984_a()) && !this.getIsAir(chunk, pos.func_177977_b());
    }

    public boolean isWall(World world, BlockPos pos) {
        return !this.getIsAir(world, pos.func_177984_a()) && !this.getIsAir(world, pos.func_177977_b());
    }

    public boolean getIsAir(Chunk chunk, BlockPos pos) {
        return BlockSets.nonSolidBlockSet.contains(chunk.func_177435_g(pos).func_177230_c());
    }

    public boolean getIsAir(World world, BlockPos pos) {
        return BlockSets.nonSolidBlockSet.contains(world.func_180495_p(pos).func_177230_c());
    }

    public boolean isSurfaceAndCheck(Chunk chunk, GeneratorMethods gen, IBlockState state, int x, int y, int z) {
        Replacer replacer;
        Block block = state.func_177230_c();
        if (BlockSets.isNonSolidAndCheckReplacement.containsKey(block) && (replacer = BlockSets.isNonSolidAndCheckReplacement.get(block)) != null) {
            replacer.isNonSolidAndReplacement(chunk, new BlockPos(x, y, z), gen, state);
        }
        return BlockSets.surfaceBlocks.contains(block);
    }

    protected ArrayList<ExtendedBlockStorage> getStorageList(Chunk chunk) {
        ArrayList<ExtendedBlockStorage> list = new ArrayList<ExtendedBlockStorage>();
        for (int loop = 0; loop < 16 && chunk.func_76587_i()[loop] != null; ++loop) {
            list.add(chunk.func_76587_i()[loop]);
        }
        return list;
    }

    protected ArrayList<IBlockState> getColumn(ArrayList<ExtendedBlockStorage> storageList, int chunkX, int chunkZ) {
        ArrayList<IBlockState> blockArray = new ArrayList<IBlockState>();
        for (ExtendedBlockStorage extendedblockstorage : storageList) {
            for (int loop = 0; loop < 16; ++loop) {
                blockArray.add(extendedblockstorage.func_177485_a(chunkX, loop, chunkZ));
            }
        }
        return blockArray;
    }
}

