/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import wtf.utilities.wrappers.AdjPos;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.XZ;

public class UnsortedChunkCaves {
    private HashMap<XZ, ArrayList<CavePosition>> unsortedCavePos = new HashMap();
    private ArrayList<CaveListWrapper> sortedCaveLists = new ArrayList();
    public final ChunkCoords coords;

    public UnsortedChunkCaves(ChunkCoords coords) {
        this.coords = coords;
    }

    public boolean addWallPos(BlockPos wall, AdjPos adj) {
        XZ xz = new XZ(adj.func_177958_n(), adj.func_177952_p());
        ArrayList<CavePosition> list = this.unsortedCavePos.get(xz);
        try {
            for (CavePosition pos : list) {
                if (pos.floor >= adj.func_177956_o() || pos.ceiling <= adj.func_177956_o()) continue;
                pos.wall.add(wall);
                pos.adj.add(adj);
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("While trying to add a wall pos on a previous column, a cave list was null");
        }
        return false;
    }

    public void add(CavePosition pos) {
        XZ xz = pos.xz();
        if (this.unsortedCavePos.containsKey(xz)) {
            this.unsortedCavePos.get(xz).add(pos);
        } else {
            ArrayList<CavePosition> list = new ArrayList<CavePosition>();
            list.add(pos);
            this.unsortedCavePos.put(xz, list);
        }
    }

    public void getSortedCaves() {
        for (Map.Entry<XZ, ArrayList<CavePosition>> entry : this.unsortedCavePos.entrySet()) {
            XZ xz = entry.getKey();
            ArrayList<CavePosition> list = entry.getValue();
            Iterator<CavePosition> listerator = list.iterator();
            while (listerator.hasNext()) {
                CavePosition cavepos = listerator.next();
                CaveListWrapper newcavelist = new CaveListWrapper(cavepos, this.coords);
                listerator.remove();
                this.addAllAdj(newcavelist, cavepos, xz);
                this.sortedCaveLists.add(newcavelist);
            }
        }
        for (CaveListWrapper wrapper : this.sortedCaveLists) {
            wrapper.setCaveArrayList();
        }
    }

    private void addAllAdj(CaveListWrapper newcavelist, CavePosition oldpos, XZ oldxz) {
        XZ[] set;
        for (XZ newxz : set = oldxz.getAdj()) {
            if (newcavelist.contains(newxz) || !this.unsortedCavePos.containsKey(newxz)) continue;
            CavePosition usepos = null;
            Iterator<CavePosition> iterator = this.unsortedCavePos.get(newxz).iterator();
            while (iterator.hasNext()) {
                CavePosition newpos = iterator.next();
                int floordiff = Math.abs(oldpos.floor - newpos.floor);
                int ceildiff = Math.abs(oldpos.ceiling - newpos.ceiling);
                if (floordiff >= 3 || ceildiff >= 4) continue;
                usepos = newpos;
                iterator.remove();
                break;
            }
            if (usepos == null) continue;
            newcavelist.addPos(usepos);
            this.addAllAdj(newcavelist, usepos, newxz);
        }
    }

    public void printReport() {
        System.out.println("Caves per chunk " + this.sortedCaveLists.size());
        for (CaveListWrapper list : this.sortedCaveLists) {
            if (list.size() <= 10) continue;
            System.out.println("New Cave");
            System.out.println(list.size());
            list.printMetrics();
        }
    }

    public int size() {
        return this.sortedCaveLists.size();
    }

    public CaveListWrapper getRandomCave(Random random) {
        CaveListWrapper list = this.sortedCaveLists.get(random.nextInt(this.sortedCaveLists.size()));
        return list;
    }

    public ArrayList<CaveListWrapper> getCaves() {
        return this.sortedCaveLists;
    }
}

