/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.concurrent.CountDownLatch;
import net.minecraft.world.World;
import wtf.Core;
import wtf.utilities.UBC.UBCGenMethods;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.CoreWorldGenListener;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.NetherScanner;
import wtf.worldgen.WorldScanner;

public class MultiThreadScanner
implements Runnable {
    private final World world;
    public final ChunkCoords coords;
    private volatile CountDownLatch latch = new CountDownLatch(1);

    public MultiThreadScanner(World world, ChunkCoords coords) {
        this.world = world;
        this.coords = coords;
    }

    public void latchOn() throws InterruptedException {
        this.latch.await();
    }

    @Override
    public void run() {
        WorldScanner scanner = null;
        switch (this.world.field_73011_w.func_186058_p()) {
            case NETHER: {
                scanner = new NetherScanner();
                break;
            }
            case OVERWORLD: {
                scanner = new WorldScanner();
                break;
            }
            case THE_END: {
                break;
            }
        }
        if (scanner != null) {
            GeneratorMethods gen = Core.UBC ? new UBCGenMethods(this.world, this.coords, this.world.field_73012_v) : new GeneratorMethods(this.world, this.coords, this.world.field_73012_v);
            ChunkScan scan = scanner.getChunkScan(this.world, this.coords, gen);
            CoreWorldGenListener.storeScan(this.world, this.coords, scan);
            CoreWorldGenListener.deRegScanner(this.world, this.coords);
            this.latch.countDown();
        }
    }
}

