/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import wtf.config.MasterConfig;
import wtf.config.OverworldGenConfig;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.CoreWorldGenListener;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.generators.CaveGenerator;
import wtf.worldgen.generators.DungeonGenerator;
import wtf.worldgen.generators.OreGenerator;
import wtf.worldgen.generators.SubBiomeGenerator;
import wtf.worldgen.generators.SurfaceGenerator;
import wtf.worldgen.generators.TickGenBuffer;
import wtf.worldgen.generators.TreeGenerator;

public class MultiThreadGenerator
implements Runnable {
    private final World world;
    public final ChunkCoords coords;
    private static final OreGenerator oreGen = new OreGenerator();
    private static final DungeonGenerator dungeonGen = new DungeonGenerator();
    private static final CaveGenerator caveGen = new CaveGenerator();
    private static final TreeGenerator treeGen = new TreeGenerator();
    private static final SubBiomeGenerator subGen = new SubBiomeGenerator();
    private static final SurfaceGenerator surfaceGen = new SurfaceGenerator();

    public MultiThreadGenerator(World world, ChunkCoords coords) {
        this.world = world;
        this.coords = coords;
    }

    @Override
    public void run() {
        ChunkScan scan = CoreWorldGenListener.getChunkScan(this.world, this.coords);
        this.generate(scan);
    }

    private void generate(ChunkScan scan) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        GeneratorMethods gen = scan.gen;
        ChunkCoords coords = scan.coords;
        if (gen == null) {
            System.out.println("******************FOUND NULL GEN");
            return;
        }
        gen.overrideBlock(scan.coords.getGenMarkerPos(), Blocks.field_150357_h.func_176223_P());
        try {
            if (MasterConfig.enableOreGen) {
                oreGen.generate(this.world, coords, random, scan, gen);
            }
            if (MasterConfig.dungeonGeneration) {
                dungeonGen.generate(this.world, coords, random, scan, gen);
            }
            if (MasterConfig.caveGeneration) {
                caveGen.generate(this.world, coords, random, scan, gen);
            }
            if (MasterConfig.enableOverworldGeneration && OverworldGenConfig.genTrees) {
                treeGen.generate(this.world, coords, random, scan, gen);
            }
            if (OverworldGenConfig.modifySurface) {
                subGen.generate(this.world, coords, random, scan, gen);
            }
            if (OverworldGenConfig.modifySurface && MasterConfig.enableOverworldGeneration) {
                surfaceGen.generate(this.world, coords, random, scan, gen);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TickGenBuffer.addMap(gen.blockmap);
        scan.gen = null;
    }
}

