/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import wtf.blocks.BlockIcicle;
import wtf.blocks.BlockRoots;
import wtf.blocks.BlockSpeleothem;
import wtf.config.CaveBiomesConfig;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.utilities.wrappers.BlockMap;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.StateAndModifier;
import wtf.worldgen.generators.queuedgen.QMobSpawner;
import wtf.worldgen.generators.queuedgen.QModify;
import wtf.worldgen.generators.queuedgen.QOreGen;
import wtf.worldgen.generators.queuedgen.QReplace;
import wtf.worldgen.generators.queuedgen.QReplaceNoCheck;
import wtf.worldgen.generators.queuedgen.QTreeReplace;

public class GeneratorMethods {
    public final Chunk chunk;
    public final BlockMap blockmap;
    public final Random random;
    private Material[] repset = new Material[]{Material.field_151597_y, Material.field_151588_w, Material.field_151598_x, Material.field_151587_i, Material.field_151586_h, Material.field_151579_a, Material.field_151577_b};
    private HashSet<Material> rephashset = new HashSet<Material>(Arrays.asList(this.repset));

    public GeneratorMethods(World world, ChunkCoords coords, Random random) {
        this.chunk = coords.getChunk(world);
        this.blockmap = new BlockMap(world, coords);
        this.random = random;
    }

    public World getWorld() {
        return this.chunk.func_177412_p();
    }

    public boolean transformBlock(BlockPos pos, BlockSets.Modifier modifier) {
        return this.blockmap.add(pos, new QModify(modifier));
    }

    public boolean replaceBlock(BlockPos pos, IBlockState state) {
        return this.blockmap.add(pos, new QReplace(state));
    }

    public boolean overrideBlock(BlockPos pos, IBlockState state) {
        return this.blockmap.add(pos, new QReplaceNoCheck(state));
    }

    public boolean setOreBlock(BlockPos pos, IBlockState oreState, int density) {
        return this.blockmap.add(pos, new QOreGen(oreState, density));
    }

    public boolean setFloorAddon(BlockPos pos, BlockSets.Modifier modifier) {
        IBlockState oldState = this.getWorld().func_180495_p(pos.func_177977_b());
        IBlockState newState = BlockSets.blockTransformer.get(new StateAndModifier(oldState, modifier));
        if (newState != null && !this.blockmap.posQueued(pos.func_177977_b())) {
            return this.replaceBlock(pos, newState);
        }
        return false;
    }

    public boolean setCeilingAddon(BlockPos pos, BlockSets.Modifier modifier) {
        IBlockState oldState = this.getWorld().func_180495_p(pos.func_177984_a());
        IBlockState newState = BlockSets.blockTransformer.get(new StateAndModifier(oldState, modifier));
        if (newState != null && !this.blockmap.posQueued(pos.func_177984_a())) {
            return this.replaceBlock(pos, newState);
        }
        return false;
    }

    public void setWaterPatch(BlockPos pos) {
        if (CaveBiomesConfig.enablePuddles) {
            this.setPatch(pos, WTFBlocks.puddle.func_176223_P());
        }
    }

    public void setPatch(BlockPos pos, IBlockState patch) {
        if (this.isAir(pos.func_177984_a()) && !this.rephashset.contains(this.getWorld().func_180495_p(pos).func_185904_a())) {
            this.replaceBlock(pos.func_177984_a(), patch);
        }
    }

    public void genFloatingStone(BlockPos pos) {
        this.replaceBlock(pos, Blocks.field_150348_b.func_176223_P());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean genSpeleothem(BlockPos pos, int size, float depth, boolean frozen) {
        BlockSpeleothem speleothem;
        int direction;
        if (this.blockmap.posQueued(pos.func_177984_a()) || this.blockmap.posQueued(pos) || this.blockmap.posQueued(pos.func_177977_b())) {
            return false;
        }
        if (frozen && (double)depth > 0.9) {
            this.genIcicle(pos);
            return true;
        }
        IBlockState above = this.getWorld().func_180495_p(pos.func_177984_a());
        IBlockState below = this.getWorld().func_180495_p(pos.func_177977_b());
        int remaining = size;
        if (this.isAir(pos.func_177984_a()) && !this.isAir(pos.func_177977_b())) {
            direction = 1;
            speleothem = WTFBlocks.speleothemMap.get(below);
        } else {
            if (this.isAir(pos.func_177984_a()) || !this.isAir(pos.func_177977_b())) return false;
            direction = -1;
            speleothem = WTFBlocks.speleothemMap.get(above);
        }
        if (speleothem == null) {
            if (direction != -1) return false;
            if (above.func_177230_c().hashCode() == Blocks.field_150346_d.hashCode() && (double)depth > 0.7) {
                this.genRoot(pos);
                return true;
            }
            if (!frozen && above.func_185904_a() != Material.field_151588_w && above.func_185904_a() != Material.field_151598_x) return false;
            this.genIcicle(pos);
            return true;
        }
        if (depth > 1.0f) {
            return false;
        }
        if (frozen) {
            speleothem = speleothem.frozen;
        }
        while (remaining > 0) {
            IBlockState next = this.getWorld().func_180495_p(pos.func_177981_b(direction));
            boolean nextQueued = this.blockmap.posQueued(pos.func_177981_b(direction));
            IBlockState set = null;
            if (!nextQueued && remaining == size) {
                if (!this.isAir(pos.func_177981_b(direction))) return false;
                set = size > 1 ? (direction == 1 ? speleothem.getBlockState(BlockSpeleothem.SpType.stalagmite_base) : speleothem.getBlockState(BlockSpeleothem.SpType.stalactite_base)) : (direction == 1 ? speleothem.getBlockState(BlockSpeleothem.SpType.stalagmite_small) : speleothem.getBlockState(BlockSpeleothem.SpType.stalactite_small));
            } else if (!nextQueued && remaining > 1) {
                if (this.isAir(pos.func_177981_b(direction))) {
                    set = speleothem.getBlockState(BlockSpeleothem.SpType.column);
                } else if (next.hashCode() == speleothem.parentBackground.hashCode()) {
                    set = direction == 1 ? speleothem.getBlockState(BlockSpeleothem.SpType.stalactite_base) : speleothem.getBlockState(BlockSpeleothem.SpType.stalagmite_base);
                    remaining = 0;
                } else {
                    set = direction == 1 ? speleothem.getBlockState(BlockSpeleothem.SpType.stalagmite_tip) : speleothem.getBlockState(BlockSpeleothem.SpType.stalactite_tip);
                }
            } else {
                set = direction == 1 ? speleothem.getBlockState(BlockSpeleothem.SpType.stalagmite_tip) : speleothem.getBlockState(BlockSpeleothem.SpType.stalactite_tip);
            }
            this.replaceBlock(pos, set);
            pos = pos.func_177981_b(direction);
            --remaining;
        }
        return true;
    }

    public void genIcicle(BlockPos pos) {
        if (this.random.nextBoolean() && this.isAir(pos.func_177977_b())) {
            this.replaceBlock(pos, WTFBlocks.icicle.getBlockState(BlockIcicle.IcicleType.icicle_base));
            this.replaceBlock(pos.func_177977_b(), WTFBlocks.icicle.getBlockState(BlockIcicle.IcicleType.icicle_tip));
        } else {
            this.replaceBlock(pos, WTFBlocks.icicle.getBlockState(BlockIcicle.IcicleType.icicle_small));
        }
    }

    public void GenVines(BlockPos pos, EnumFacing facing) {
        if (!this.isAir(pos)) {
            return;
        }
        IBlockState block = null;
        switch (facing) {
            case EAST: {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true));
                break;
            }
            case NORTH: {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true));
                break;
            }
            case SOUTH: {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true));
                break;
            }
            case WEST: {
                block = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true));
            }
        }
        this.replaceBlock(pos, block);
    }

    public void genRoot(BlockPos pos) {
        Biome biome = this.chunk.func_177411_a(pos, this.chunk.func_177412_p().func_72959_q());
        if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
            this.replaceBlock(pos, WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.spruce)));
        } else if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
            this.replaceBlock(pos, WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.acacia)));
        } else if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            this.replaceBlock(pos, WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.jungle)));
        } else if (biome.func_185359_l().contains("ark")) {
            this.replaceBlock(pos, WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.big_oak)));
        } else if (biome.func_185359_l().contains("irch")) {
            this.replaceBlock(pos, WTFBlocks.roots.func_176223_P().func_177226_a(BlockRoots.TYPE, (Comparable)((Object)BlockRoots.RootType.birch)));
        } else {
            this.replaceBlock(pos, WTFBlocks.roots.func_176223_P());
        }
    }

    public void spawnVanillaSpawner(BlockPos pos, String entityName, int count) {
        this.blockmap.add(pos, new QMobSpawner(this.getWorld(), pos, entityName, count));
    }

    private boolean isAir(BlockPos pos) {
        return this.getWorld().func_175623_d(pos) && !this.blockmap.posQueued(pos);
    }

    public boolean setTreeBlock(BlockPos pos, IBlockState state) {
        return this.blockmap.add(pos, new QTreeReplace(pos, state));
    }
}

