/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.HashMap;
import net.minecraft.world.World;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.MultiThreadGenerator;
import wtf.worldgen.MultiThreadScanner;

public class GenScanMap {
    private volatile HashMap<ChunkCoords, ChunkScan> worldChunkScans;
    private volatile HashMap<ChunkCoords, MultiThreadScanner> scanners;
    private volatile HashMap<ChunkCoords, MultiThreadGenerator> generators;
    public final World world;

    public GenScanMap(World world) {
        this.world = world;
        this.worldChunkScans = new HashMap();
        this.scanners = new HashMap();
        this.generators = new HashMap();
    }

    public ChunkScan getChunkScan(ChunkCoords coords) {
        return this.worldChunkScans.get(coords);
    }

    public int scannersRemaining() {
        return this.scanners.size();
    }

    public void storeScan(ChunkCoords coords, ChunkScan scan) {
        this.worldChunkScans.put(coords, scan);
    }

    public void storeGenerator(MultiThreadGenerator gen) {
        this.generators.put(gen.coords, gen);
    }

    public void removeGenerator(ChunkCoords coords) {
        this.generators.remove(coords);
    }

    public boolean containsGenerator(ChunkCoords coords) {
        return this.generators.containsKey(coords);
    }

    public void regScanner(MultiThreadScanner scanner) {
        this.scanners.put(scanner.coords, scanner);
    }

    public MultiThreadScanner getScanner(ChunkCoords coords) {
        return this.scanners.get(coords);
    }

    public void deRegScanner(ChunkCoords coords) {
        this.scanners.remove(coords);
    }

    public boolean scanStarted(ChunkCoords coords) {
        return this.scanners.containsKey(coords) || this.worldChunkScans.containsKey(coords);
    }
}

