/*
 * Decompiled with CFR 0.152.
 */
package wtf.worldgen;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import wtf.Core;
import wtf.init.WTFBlocks;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.GenScanMap;
import wtf.worldgen.MultiThreadGenerator;
import wtf.worldgen.MultiThreadScanner;

public class CoreWorldGenListener {
    private static ExecutorService executor;
    public static HashMap<Integer, GenScanMap> masterMap;

    public CoreWorldGenListener() {
        executor = Executors.newFixedThreadPool(5);
        masterMap = new HashMap();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void populate(PopulateChunkEvent.Post event) {
        if (event.getWorld().field_72995_K || event.getWorld().func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        if (event.getWorld().field_73011_w.func_186058_p() == DimensionType.THE_END) {
            return;
        }
        GenScanMap worldMap = masterMap.get(event.getWorld().field_73011_w.getDimension());
        if (worldMap == null) {
            worldMap = new GenScanMap(event.getWorld());
            masterMap.put(event.getWorld().field_73011_w.getDimension(), worldMap);
        }
        ChunkCoords coords = new ChunkCoords(event.getChunkX(), event.getChunkZ());
        BlockPos pos = coords.getGenMarkerPos();
        if (event.getWorld().func_175623_d(coords.getGenMarkerPos())) {
            return;
        }
        event.getWorld().func_175656_a(pos, WTFBlocks.genMarker.func_176223_P());
        for (ChunkCoords adjCoords : coords.getChunksInRadius(1)) {
            if (!CoreWorldGenListener.shouldScan(worldMap, adjCoords)) continue;
            MultiThreadScanner scanner = new MultiThreadScanner(event.getWorld(), adjCoords);
            worldMap.regScanner(scanner);
            executor.execute(scanner);
        }
        for (ChunkCoords adjCoords : coords.getChunksInRadius(2)) {
            if (!CoreWorldGenListener.readyForGen(worldMap, adjCoords)) continue;
            MultiThreadGenerator generator = new MultiThreadGenerator(event.getWorld(), adjCoords);
            worldMap.storeGenerator(generator);
            executor.execute(generator);
        }
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        ChunkCoords coords = new ChunkCoords(event.getChunk().field_76635_g, event.getChunk().field_76647_h);
        if (event.getWorld().field_72995_K || event.getWorld().func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        GenScanMap worldMap = masterMap.get(event.getWorld().field_73011_w.getDimension());
        if (worldMap == null) {
            worldMap = new GenScanMap(event.getWorld());
            masterMap.put(event.getWorld().field_73011_w.getDimension(), worldMap);
        }
        if (coords.isWTFGenerated(event.getWorld())) {
            return;
        }
        for (ChunkCoords adjCoords : coords.getChunksInRadius(1)) {
            if (!CoreWorldGenListener.shouldScan(worldMap, adjCoords)) continue;
            MultiThreadScanner scanner = new MultiThreadScanner(event.getWorld(), adjCoords);
            worldMap.regScanner(scanner);
            executor.execute(scanner);
        }
        for (ChunkCoords adjCoords : coords.getChunksInRadius(2)) {
            if (!CoreWorldGenListener.readyForGen(worldMap, adjCoords)) continue;
            MultiThreadGenerator generator = new MultiThreadGenerator(event.getWorld(), adjCoords);
            worldMap.storeGenerator(generator);
            executor.execute(generator);
        }
    }

    private static boolean shouldScan(GenScanMap worldMap, ChunkCoords coords) {
        if (!coords.exists(worldMap.world) || worldMap.getScanner(coords) != null || worldMap.getChunkScan(coords) != null) {
            return false;
        }
        for (ChunkCoords checkCoords : coords.getChunksInRadius(1)) {
            if (checkCoords.isPopulated(worldMap.world)) continue;
            return false;
        }
        return true;
    }

    private static boolean readyForGen(GenScanMap worldMap, ChunkCoords coords) {
        if (!coords.exists(worldMap.world)) {
            return false;
        }
        if (worldMap.containsGenerator(coords) || coords.isWTFGenerated(worldMap.world)) {
            return false;
        }
        for (ChunkCoords checkCoords : coords.getChunksInRadius(1)) {
            if (!checkCoords.exists(worldMap.world)) {
                return false;
            }
            if (worldMap.scanStarted(checkCoords)) continue;
            if (CoreWorldGenListener.shouldScan(worldMap, checkCoords)) {
                MultiThreadScanner scanner = new MultiThreadScanner(worldMap.world, checkCoords);
                worldMap.regScanner(scanner);
                executor.execute(scanner);
                continue;
            }
            return false;
        }
        return true;
    }

    public static ChunkScan getChunkScan(World world, ChunkCoords coords) {
        GenScanMap worldMap = masterMap.get(world.field_73011_w.getDimension());
        ChunkScan scan = worldMap.getChunkScan(coords);
        if (scan != null) {
            return scan;
        }
        MultiThreadScanner scanner = worldMap.getScanner(coords);
        if (scanner != null) {
            try {
                scanner.latchOn();
                return worldMap.getChunkScan(coords);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            if (CoreWorldGenListener.shouldScan(worldMap, coords)) {
                scanner = new MultiThreadScanner(world, coords);
                worldMap.regScanner(scanner);
                executor.execute(scanner);
                try {
                    scanner.latchOn();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return worldMap.getChunkScan(coords);
            }
            Core.coreLog.info("Trying to get a chunkscan for a chunk that isn't ready to be scanned");
        }
        return scan;
    }

    public static void storeScan(World world, ChunkCoords coords, ChunkScan scan) {
        GenScanMap map = masterMap.get(world.field_73011_w.getDimension());
        map.storeScan(coords, scan);
    }

    public static void deRegScanner(World world, ChunkCoords coords) {
        masterMap.get(world.field_73011_w.getDimension()).deRegScanner(coords);
    }

    public static void deRegGenerator(World world, ChunkCoords coords) {
        masterMap.get(world.field_73011_w.getDimension()).removeGenerator(coords);
    }
}

