/*
 * Decompiled with CFR 0.152.
 */
package wtf.utilities.wrappers;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.SurfacePos;
import wtf.worldgen.CoreWorldGenListener;
import wtf.worldgen.GeneratorMethods;
import wtf.worldgen.UnsortedChunkCaves;

public class ChunkScan {
    public final SurfacePos[][] surface;
    public final World world;
    public final ChunkCoords coords;
    public final double surfaceAvg;
    public GeneratorMethods gen;
    public final UnsortedChunkCaves caveset;
    private final ArrayList<BlockPos> underwater;

    public ChunkScan(World world, ChunkCoords coords, GeneratorMethods gen, SurfacePos[][] var, int avg, UnsortedChunkCaves unsortedcavepos, ArrayList<BlockPos> water) {
        this.surface = var;
        this.coords = coords;
        this.surfaceAvg = avg;
        this.world = world;
        this.caveset = unsortedcavepos;
        this.underwater = water;
        this.gen = gen;
    }

    public Block getBlockInChunk(int x, int z) {
        return this.world.func_180495_p((BlockPos)this.surface[x][z]).func_177230_c();
    }

    public SurfacePos getSurfacePosFromWorldCoords(int worldx, int worldz) {
        int x = worldx - this.coords.getChunkX();
        int z = worldz - this.coords.getChunkZ();
        if (x > -1 && x < 16 && z > -1 && z < 16) {
            return this.surface[x][z];
        }
        return null;
    }

    public SurfacePos getRandomNotGenerated(Random random) {
        for (int tryloop = 0; tryloop < 5; ++tryloop) {
            int x = random.nextInt(16);
            int z = random.nextInt(16);
            if (this.surface[x][z].generated) continue;
            return this.surface[x][z];
        }
        return null;
    }

    public ArrayList<BlockPos> getWaterList() {
        return this.underwater;
    }

    public void setGenerated(BlockPos pos) {
        int x = pos.func_177958_n() - this.coords.getWorldX();
        int z = pos.func_177952_p() - this.coords.getWorldZ();
        if (x < 16 && x > -1 && z < 16 && z > -1) {
            this.surface[x][z].generated = true;
        } else {
            ChunkCoords adj = new ChunkCoords(pos);
            ChunkScan scan = CoreWorldGenListener.getChunkScan(this.world, adj);
            if (scan != null) {
                scan.setGenerated(pos);
            }
        }
    }

    public boolean checkGenerated(BlockPos pos, double d) {
        int x = pos.func_177958_n() - this.coords.getChunkX();
        int z = pos.func_177952_p() - this.coords.getChunkZ();
        double radius2 = d * d;
        for (double loopX = -d; loopX < d; loopX += 1.0) {
            for (double loopZ = -d; loopZ < d; loopZ += 1.0) {
                int scanx = (int)(loopX + (double)x);
                int scanz = (int)(loopZ + (double)z);
                int rad = (int)(loopX * loopX + loopZ * loopZ);
                if (!((double)rad < radius2) || scanx >= 16 || scanx <= -1 || scanz >= 16 || scanz <= -1 || !this.surface[scanx][scanz].generated) continue;
                return true;
            }
        }
        return false;
    }
}

