/*
 * Decompiled with CFR 0.152.
 */
package wtf.utilities.wrappers;

import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import wtf.blocks.GenPlaceHolder;

public class ChunkCoords {
    private final int x;
    private final int z;

    public ChunkCoords(int chunkX, int chunkZ) {
        this.x = chunkX;
        this.z = chunkZ;
    }

    public ChunkCoords(BlockPos pos) {
        this.x = pos.func_177958_n() >> 4;
        this.z = pos.func_177952_p() >> 4;
    }

    public int getChunkX() {
        return this.x;
    }

    public int getChunkZ() {
        return this.z;
    }

    public int getWorldX() {
        return this.x << 4;
    }

    public int getWorldZ() {
        return this.z << 4;
    }

    public Chunk getChunk(World world) {
        return world.func_72964_e(this.x, this.z);
    }

    public BlockPos getGenMarkerPos() {
        return new BlockPos(this.getWorldX() + 8, 0, this.getWorldZ() + 8);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.z;
        return result;
    }

    public ArrayList<ChunkCoords> getChunksInRadius(int radius) {
        ArrayList<ChunkCoords> arraylist = new ArrayList<ChunkCoords>();
        for (int xloop = -radius; xloop < radius + 1; ++xloop) {
            for (int zloop = -radius; zloop < radius + 1; ++zloop) {
                if (xloop == 0 && zloop == 0) continue;
                arraylist.add(new ChunkCoords(this.x + xloop, this.z + zloop));
            }
        }
        return arraylist;
    }

    public boolean exists(World world) {
        return ((ChunkProviderServer)world.func_72863_F()).func_73149_a(this.x, this.z);
    }

    public boolean isPopulated(World world) {
        return ((ChunkProviderServer)world.func_72863_F()).func_73149_a(this.x, this.z) && this.getChunk(world).func_177419_t();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkCoords other = (ChunkCoords)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.z == other.z;
    }

    public boolean isWTFGenerated(World world) {
        return !(world.func_180495_p(this.getGenMarkerPos()).func_177230_c() instanceof GenPlaceHolder);
    }
}

