/*
 * Decompiled with CFR 0.152.
 */
package wtf.utilities.wrappers;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import wtf.utilities.wrappers.AdjPos;
import wtf.utilities.wrappers.XZ;

public class CavePosition {
    public final int floor;
    public final int ceiling;
    public final int x;
    public final int z;
    public ArrayList<AdjPos> adj = new ArrayList();
    public ArrayList<BlockPos> wall = new ArrayList();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ceiling;
        result = 31 * result + this.floor;
        result = 31 * result + this.x;
        result = 31 * result + this.z;
        return result;
    }

    public BlockPos getFloorPos() {
        return new BlockPos(this.x, this.floor, this.z);
    }

    public BlockPos getCeilingPos() {
        return new BlockPos(this.x, this.ceiling, this.z);
    }

    public XZ xz() {
        return new XZ(this.x, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CavePosition other = (CavePosition)obj;
        if (this.ceiling != other.ceiling) {
            return false;
        }
        if (this.floor != other.floor) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.z == other.z;
    }

    public CavePosition(int p_i45363_1_, int p_i45363_2_, int p_i45363_3_, int p_i45363_4_) {
        this.x = p_i45363_1_;
        this.ceiling = p_i45363_2_;
        this.floor = p_i45363_3_;
        this.z = p_i45363_4_;
    }

    public BlockPos getRandomWall(Random random) {
        if (this.wall.size() > 1) {
            return this.wall.get(random.nextInt(this.wall.size()));
        }
        return null;
    }

    public BlockPos getMidPos() {
        return new BlockPos(this.x, this.ceiling - this.floor / 2 + this.floor, this.z);
    }

    public ArrayList<BlockPos> getAirPos() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos pos = this.getFloorPos().func_177984_a();
        while (pos.func_177956_o() < this.ceiling) {
            list.add(pos);
            pos = pos.func_177984_a();
        }
        return list;
    }
}

