/*
 * Decompiled with CFR 0.152.
 */
package wtf.utilities.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.CavePosition;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.XZ;

public class CaveListWrapper {
    private final HashMap<XZ, CavePosition> cave;
    private ArrayList<CavePosition> cavelist = new ArrayList();
    private final ChunkCoords coords;
    private ArrayList<BlockPos> wallpos = new ArrayList();
    private double totalFloor = 0.0;
    private double totalCeiling = 0.0;
    private double totalX = 0.0;
    private double totalZ = 0.0;
    int minFloor;
    int minCeiling;
    int minX;
    int minZ;
    int maxFloor;
    int maxCeiling;
    int maxX;
    int maxZ;
    int centerDistToWall = -1;
    public CavePosition centerpos = null;
    int airHash = Material.field_151579_a.hashCode();

    public void printMetrics() {
        System.out.println("sizeX = " + this.getSizeX());
        System.out.println("sizeZ = " + this.getSizeZ());
        if (this.size() > 10) {
            System.out.println("is away from Edge " + this.isAwayFromEdge());
            System.out.println("density = " + this.density());
        }
    }

    public CaveListWrapper(CavePosition pos, ChunkCoords coords) {
        this.coords = coords;
        this.cave = new HashMap();
        this.addPos(pos);
        this.maxFloor = pos.floor;
        this.minFloor = pos.floor;
        this.maxCeiling = pos.ceiling;
        this.minCeiling = pos.ceiling;
        this.minX = pos.x;
        this.maxX = pos.x;
        this.minZ = pos.z;
        this.maxZ = pos.z;
    }

    public boolean contains(XZ xz) {
        return this.cave.containsKey(xz);
    }

    public Collection<CavePosition> getCaveSet() {
        return this.cave.values();
    }

    public void addPos(CavePosition pos) {
        this.wallpos.addAll(pos.wall);
        this.cave.put(pos.xz(), pos);
        this.totalFloor += (double)pos.floor;
        this.totalCeiling += (double)pos.ceiling;
        this.totalX += (double)pos.x;
        this.totalZ += (double)pos.z;
        this.maxFloor = this.maxFloor < pos.floor ? pos.floor : this.maxFloor;
        this.minFloor = this.minFloor > pos.floor ? pos.floor : this.minFloor;
        this.maxCeiling = this.maxCeiling < pos.ceiling ? pos.ceiling : this.maxCeiling;
        this.minCeiling = this.minCeiling > pos.ceiling ? pos.ceiling : this.minCeiling;
        this.minX = this.minX > pos.x ? pos.x : this.minX;
        this.maxX = this.maxX < pos.x ? pos.x : this.maxX;
        this.minZ = this.minZ > pos.z ? pos.z : this.minZ;
        this.maxZ = this.maxZ < pos.z ? pos.z : this.maxZ;
    }

    public boolean isAwayFromEdge() {
        double chunkx = this.getAvgX() - (double)this.coords.getWorldX();
        double chunkz = this.getAvgZ() - (double)this.coords.getWorldZ();
        boolean inX = chunkx + this.getSizeX() / 2.0 < 17.0 && chunkx - this.getSizeX() / 2.0 > -1.0;
        boolean inZ = chunkx + this.getSizeZ() / 2.0 < 17.0 && chunkz - this.getSizeZ() / 2.0 > -1.0;
        return inX && inZ;
    }

    public double density() {
        double area = Math.PI * (this.getSizeX() / 2.0) * (this.getSizeZ() / 2.0);
        double density = (float)((double)this.size() / area);
        return density;
    }

    public double getAvgFloor() {
        return this.totalFloor / (double)this.cave.size();
    }

    public double getAvgCeiling() {
        return this.totalCeiling / (double)this.cave.size();
    }

    public double getAvgX() {
        return this.totalX / (double)this.cave.size();
    }

    public double getAvgZ() {
        return this.totalZ / (double)this.cave.size();
    }

    public Biome getBiome(World world) {
        return world.getBiomeForCoordsBody(new BlockPos(this.getAvgX(), this.getAvgFloor(), this.getAvgZ()));
    }

    public double getSizeX() {
        return this.maxX - this.minX;
    }

    public double getSizeZ() {
        return this.maxZ - this.minZ;
    }

    public CavePosition getCenter() {
        return this.centerpos;
    }

    public double getCenterScore() {
        CavePosition bestpos = null;
        double bestscore = 10.0;
        for (CavePosition checkpos : this.cavelist) {
            double posFailScore = this.getClearance(checkpos);
            if (posFailScore < bestscore) {
                bestpos = checkpos;
                bestscore = posFailScore;
                continue;
            }
            if (posFailScore != bestscore) continue;
            if (checkpos.ceiling - checkpos.floor > bestpos.ceiling - bestpos.floor) {
                bestpos = checkpos;
                continue;
            }
            if (checkpos.ceiling - checkpos.floor != bestpos.ceiling - bestpos.floor) continue;
        }
        this.centerpos = bestpos;
        return bestscore;
    }

    public double getClearance(CavePosition pos) {
        if (4 > pos.ceiling - pos.floor) {
            return 100.0;
        }
        int loop = 4;
        double failScore = 0.0;
        for (int xloop = -loop; xloop <= loop; ++xloop) {
            for (int zloop = -loop; zloop <= loop; ++zloop) {
                CavePosition checkpos = this.cave.get(new XZ(pos.x + xloop, pos.z + zloop));
                if (checkpos != null) {
                    if (pos.floor == checkpos.floor) continue;
                    double floorDif = pos.floor - checkpos.floor;
                    double score = floorDif * floorDif / (double)(xloop * xloop + zloop * zloop);
                    failScore += score;
                    continue;
                }
                double score = 10.0 / (double)(xloop * xloop + zloop * zloop);
                failScore += score;
            }
        }
        return failScore;
    }

    public double dungeonScore(World world, double surfaceAvg) {
        if (this.size() < 25) {
            return 0.0;
        }
        if (this.density() < 0.9) {
            return 0.0;
        }
        if (this.minFloor < 12) {
            return 0.0;
        }
        if ((double)this.maxCeiling > surfaceAvg) {
            return 0.0;
        }
        if (this.getSizeX() < 5.0 || this.getSizeZ() < 5.0 || this.getSizeX() + this.getSizeZ() < 14.0) {
            return 0.0;
        }
        if (!this.isAwayFromEdge()) {
            return 0.0;
        }
        double failScore = this.getCenterScore();
        if (this.centerpos == null) {
            return 0.0;
        }
        if (4 > this.centerpos.ceiling - this.centerpos.floor || 4.0 > this.getAvgCeiling() - this.getAvgFloor()) {
            return 0.0;
        }
        IBlockState state = world.func_180495_p(this.centerpos.getFloorPos());
        IBlockState up = world.func_180495_p(this.centerpos.getFloorPos().func_177984_a());
        if (!BlockSets.ReplaceHashset.contains(state.func_177230_c()) && up.func_185904_a().hashCode() != this.airHash) {
            return 0.0;
        }
        return 100.0 - failScore;
    }

    public CavePosition getRandomPosition(Random random) {
        return this.cavelist.get(random.nextInt(this.cavelist.size()));
    }

    public BlockPos getRandomWall(Random random) {
        return this.wallpos.size() > 0 ? this.wallpos.get(random.nextInt(this.wallpos.size())) : null;
    }

    public int size() {
        return this.cave.size();
    }

    public double distFromCenter(CavePosition cavepos) {
        int x = this.centerpos.getFloorPos().func_177958_n() - cavepos.getFloorPos().func_177958_n();
        int z = this.centerpos.getFloorPos().func_177952_p() - cavepos.getFloorPos().func_177952_p();
        return x * x + z * z;
    }

    public double distFromCenter(BlockPos pos) {
        BlockPos center = this.centerpos.getMidPos();
        int x = center.func_177958_n() - pos.func_177958_n();
        int y = center.func_177956_o() - pos.func_177956_o();
        int z = center.func_177952_p() - pos.func_177952_p();
        return Math.sqrt(x * x + y * y + z * z);
    }

    public void setCaveArrayList() {
        this.cavelist.addAll(this.cave.values());
    }

    public double getWallDist(CavePosition pos1) {
        double dist = 9.9999999E7;
        for (CavePosition pos2 : this.cave.values()) {
            int zdif;
            int xdif;
            int distsq;
            if (pos2.wall.size() <= 0 || !((double)(distsq = (xdif = pos2.x - pos1.x) * xdif + (zdif = pos2.z - pos1.z) * zdif) < dist)) continue;
            dist = distsq;
        }
        double smallest = Math.sqrt(dist);
        smallest = (double)(pos1.x - this.coords.getWorldX()) < smallest ? (double)(pos1.x - this.coords.getWorldX()) : smallest;
        smallest = (double)(this.coords.getWorldX() + 16 - pos1.x) < smallest ? (double)(this.coords.getWorldX() + 16 - pos1.x) : smallest;
        smallest = (double)(pos1.z - this.coords.getWorldZ()) < smallest ? (double)(pos1.z - this.coords.getWorldZ()) : smallest;
        smallest = (double)(this.coords.getWorldZ() + 16 - pos1.z) < smallest ? (double)(this.coords.getWorldZ() + 16 - pos1.z) : smallest;
        return smallest;
    }
}

