/*
 * Decompiled with CFR 0.152.
 */
package wtf.utilities.wrappers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.worldgen.CoreWorldGenListener;
import wtf.worldgen.generators.queuedgen.QReplaceNoCheck;
import wtf.worldgen.generators.queuedgen.QueuedGenerator;

public class BlockMap {
    private final HashMap<ChunkStorCoords, HashMap<StoragePos, Queue<QueuedGenerator>>> map;
    public final ChunkCoords coords;
    private final World world;

    public BlockMap(World world, ChunkCoords coords) {
        this.world = world;
        this.coords = coords;
        this.map = new HashMap();
    }

    public boolean posQueued(BlockPos pos) {
        return this.map.get(new ChunkStorCoords(pos)) != null ? this.map.get(new ChunkStorCoords(pos)).get(new StoragePos(pos)) != null : false;
    }

    public boolean add(BlockPos pos, QueuedGenerator qg) {
        if (qg != null) {
            Queue<QueuedGenerator> q;
            if (pos.func_177956_o() < 0 || pos.func_177956_o() >= this.world.func_72800_K()) {
                return false;
            }
            ChunkStorCoords storcoords = new ChunkStorCoords(pos);
            HashMap<StoragePos, Queue<QueuedGenerator>> exstor = this.map.get(storcoords);
            if (exstor == null) {
                exstor = new HashMap();
                this.map.put(storcoords, exstor);
            }
            if ((q = exstor.get(pos)) == null) {
                q = new LinkedList<QueuedGenerator>();
                exstor.put(new StoragePos(pos), q);
            }
            return q.add(qg);
        }
        try {
            throw new Exception("Trying to add a null QueuedGenerator");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setBlocks() {
        HashSet chunks = new HashSet();
        for (Map.Entry<ChunkStorCoords, HashMap<StoragePos, Queue<QueuedGenerator>>> mapentry : this.map.entrySet()) {
            ExtendedBlockStorage extendedblockstorage = mapentry.getKey().getStorage(this.world);
            for (Map.Entry<StoragePos, Queue<QueuedGenerator>> entry : mapentry.getValue().entrySet()) {
                IBlockState oldstate = extendedblockstorage.func_177485_a(entry.getKey().x, entry.getKey().y, entry.getKey().z);
                while (!entry.getValue().isEmpty()) {
                    QueuedGenerator qg = entry.getValue().poll();
                    IBlockState newstate = qg.getBlockState(oldstate);
                    if (newstate == null || !(qg instanceof QReplaceNoCheck) && !BlockSets.ReplaceHashset.contains(oldstate.func_177230_c())) continue;
                    extendedblockstorage.func_177484_a(entry.getKey().x, entry.getKey().y, entry.getKey().z, newstate);
                    oldstate = newstate;
                }
                this.world.func_184138_a(entry.getKey().pos, oldstate, oldstate, 3);
            }
        }
        CoreWorldGenListener.deRegGenerator(this.world, this.coords);
        for (Chunk chunk : chunks) {
            chunk.func_150809_p();
        }
    }

    private class StoragePos {
        final int x;
        final int y;
        final int z;
        final BlockPos pos;

        public int hashCode() {
            return this.x + this.y * 16 + this.z * 256;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StoragePos other = (StoragePos)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.x != other.x) {
                return false;
            }
            if (this.y != other.y) {
                return false;
            }
            return this.z == other.z;
        }

        public StoragePos(BlockPos pos) {
            this.x = pos.func_177958_n() & 0xF;
            this.y = pos.func_177956_o() & 0xF;
            this.z = pos.func_177952_p() & 0xF;
            this.pos = pos;
        }

        private BlockMap getOuterType() {
            return BlockMap.this;
        }
    }

    private class ChunkStorCoords {
        private final int chunkX;
        private final int chunkZ;
        private final int storY;

        public int hashCode() {
            int relX = this.chunkX - BlockMap.this.coords.getChunkX();
            int relZ = this.chunkZ - BlockMap.this.coords.getChunkZ();
            int xz = relX + 100 + (relZ + 10) * 1000;
            return 16 * xz + this.storY;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkStorCoords other = (ChunkStorCoords)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.chunkX != other.chunkX) {
                return false;
            }
            if (this.chunkZ != other.chunkZ) {
                return false;
            }
            return this.storY == other.storY;
        }

        public ChunkStorCoords(BlockPos pos) {
            this.chunkX = pos.func_177958_n() >> 4;
            this.chunkZ = pos.func_177952_p() >> 4;
            this.storY = pos.func_177956_o() >> 4;
        }

        private BlockMap getOuterType() {
            return BlockMap.this;
        }

        private ExtendedBlockStorage getStorage(World world) {
            ExtendedBlockStorage storage;
            Chunk chunk = world.func_72964_e(this.chunkX, this.chunkZ);
            if (!BlockMap.this.coords.exists(world)) {
                System.out.println("The generator is attempting to get an ungenerated chunk. " + this.chunkX + " " + this.chunkZ);
            }
            if ((storage = chunk.func_76587_i()[this.storY]) == Chunk.field_186036_a) {
                chunk.func_76587_i()[this.storY] = storage = new ExtendedBlockStorage(this.storY << 4, !world.field_73011_w.func_177495_o());
            }
            return storage;
        }
    }
}

