/*
 * Decompiled with CFR 0.152.
 */
package wtf.utilities.simplex;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import wtf.utilities.simplex.Simplex;

public class SimplexHelper {
    public final String name;
    public Simplex simplex = null;

    public SimplexHelper(String simplexName) {
        this.name = simplexName;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public SimplexHelper(String simplexName, boolean boo) {
        this.name = simplexName;
    }

    public double get2DNoise(World world, BlockPos pos) {
        return this.get2DNoise(world, pos.func_177958_n(), pos.func_177952_p());
    }

    public double get2DNoise(World world, double x, double z) {
        try {
            return this.simplex.noise(x, z) * 0.5 + 0.5;
        }
        catch (NullPointerException e) {
            int seed = (int)world.func_72905_C();
            this.simplex = new Simplex(seed * this.hashCode());
            return this.simplex.noise(x, z) * 0.5 + 0.5;
        }
    }

    public double get2DRandom(World world, BlockPos pos) {
        return this.get2DNoise(world, pos.func_177958_n() * 1000, pos.func_177952_p() * 1000);
    }

    public double get3DRandom(World world, BlockPos pos) {
        return this.get3DNoise(world, pos.func_177958_n() * 1000, pos.func_177956_o() * 1000, pos.func_177952_p() * 1000);
    }

    public double get3DNoise(World world, BlockPos pos) {
        return this.get3DNoise(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public double get3DNoiseShifted(World world, BlockPos pos, int shift) {
        return this.get3DNoise(world, pos.func_177958_n() + shift, pos.func_177956_o() + shift, pos.func_177952_p() + shift);
    }

    public double get3DNoiseScaled(World world, BlockPos pos, double multiplier) {
        return this.get3DNoise(world, (double)pos.func_177958_n() * multiplier, (double)pos.func_177956_o() * multiplier, (double)pos.func_177952_p() * multiplier);
    }

    public double get3DNoise(World world, double d, double y, double f) {
        try {
            return this.simplex.noise(d, y, f) * 0.5 + 0.5;
        }
        catch (NullPointerException e) {
            int seed = (int)world.func_72905_C();
            this.simplex = new Simplex(seed * this.hashCode());
            return this.simplex.noise(d, y, f) * 0.5 + 0.5;
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            System.out.println("Clearing world variable for simplex " + this.name);
            this.simplex = null;
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

