/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.oregenerators;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.ores.OreGenAbstract;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.GeneratorMethods;

public class OreGenVanilla
extends OreGenAbstract {
    protected final int blocksPerCluster;

    public OreGenVanilla(IBlockState blockstate, int[] genRange, int[] minmaxPerChunk, boolean denseGen, int blocks) {
        super(blockstate, genRange, minmaxPerChunk, denseGen);
        this.blocksPerCluster = blocks;
    }

    @Override
    public void doOreGen(World world, GeneratorMethods gen, Random random, ChunkCoords coords, ChunkScan scan) throws Exception {
        int genHeight;
        int blocksReq = this.blocksReq();
        for (int blocksPerChunk = this.getBlocksPerChunk(world, coords, random, scan.surfaceAvg); blocksPerChunk > blocksReq || blocksPerChunk > 0 && random.nextInt(blocksReq) < blocksPerChunk; blocksPerChunk -= this.genVein(world, gen, random, scan, new BlockPos(coords.getWorldX() + 8, genHeight, coords.getWorldZ() + 8))) {
            genHeight = this.getGenStartHeight(scan.surfaceAvg, random);
        }
    }

    @Override
    public int genVein(World world, GeneratorMethods gen, Random random, ChunkScan scan, BlockPos pos) throws Exception {
        float f = random.nextFloat() * (float)Math.PI;
        int blocksSet = 0;
        double d0 = (float)pos.func_177958_n() + MathHelper.func_76126_a((float)f) * (float)this.blocksPerCluster / 8.0f;
        double d1 = (float)pos.func_177958_n() - MathHelper.func_76126_a((float)f) * (float)this.blocksPerCluster / 8.0f;
        double d2 = (float)(pos.func_177952_p() + 8) + MathHelper.func_76134_b((float)f) * (float)this.blocksPerCluster / 8.0f;
        double d3 = (float)(pos.func_177952_p() + 8) - MathHelper.func_76134_b((float)f) * (float)this.blocksPerCluster / 8.0f;
        double d4 = pos.func_177956_o() + random.nextInt(3) - 2;
        double d5 = pos.func_177956_o() + random.nextInt(3) - 2;
        for (int l = 0; l <= this.blocksPerCluster; ++l) {
            double d6 = d0 + (d1 - d0) * (double)l / (double)this.blocksPerCluster;
            double d7 = d4 + (d5 - d4) * (double)l / (double)this.blocksPerCluster;
            double d8 = d2 + (d3 - d2) * (double)l / (double)this.blocksPerCluster;
            double d9 = random.nextDouble() * (double)this.blocksPerCluster / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.blocksPerCluster)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)l * (float)Math.PI / (float)this.blocksPerCluster)) + 1.0f) * d9 + 1.0;
            int i1 = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int j1 = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int k1 = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int l1 = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int i2 = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int j2 = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int k2 = i1; k2 <= l1; ++k2) {
                double d12 = ((double)k2 + 0.5 - d6) / (d10 / 2.0);
                if (!(d12 * d12 < 1.0)) continue;
                for (int l2 = j1; l2 <= i2; ++l2) {
                    double d13 = ((double)l2 + 0.5 - d7) / (d11 / 2.0);
                    if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                    for (int i3 = k1; i3 <= j2; ++i3) {
                        int densityToSet = this.genDenseOres ? this.getDensityToSet(random, l2, scan.surfaceAvg) : 0;
                        if (!(random.nextFloat() < this.veinDensity.floatValue())) continue;
                        blocksSet += densityToSet + 1;
                        gen.setOreBlock(new BlockPos(k2, l2, i3), this.oreBlock, densityToSet);
                    }
                }
            }
        }
        return blocksSet;
    }

    @Override
    public int blocksReq() {
        return (int)((float)this.blocksPerCluster * this.veinDensity.floatValue()) * 2;
    }
}

