/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.oregenerators;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import wtf.ores.OreGenAbstract;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.GeneratorMethods;

public class OreGenCluster
extends OreGenAbstract {
    public OreGenCluster(IBlockState blockstate, int[] genRange, int[] minmaxPerChunk, boolean denseGen) {
        super(blockstate, genRange, minmaxPerChunk, denseGen);
    }

    @Override
    public void doOreGen(World world, GeneratorMethods gen, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        int z;
        int y;
        int x;
        int blocksReq = (int)(6.0f * this.veinDensity.floatValue());
        for (int blocksPerChunk = this.getBlocksPerChunk(world, coords, random, chunkscan.surfaceAvg); blocksPerChunk > blocksReq || blocksPerChunk > 0 && random.nextInt(blocksReq) < blocksPerChunk; blocksPerChunk -= this.genVein(world, gen, random, chunkscan, new BlockPos(x, y, z))) {
            x = coords.getWorldX() + random.nextInt(12) + 2;
            y = this.getGenStartHeight(chunkscan.surfaceAvg, random);
            z = coords.getWorldZ() + random.nextInt(16);
        }
    }

    @Override
    public int genVein(World world, GeneratorMethods gen, Random random, ChunkScan chunkscan, BlockPos pos) throws Exception {
        int blocksPerChunk = 0;
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(gen, world, random, pos, chunkscan.surfaceAvg);
        }
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(gen, world, random, pos.func_177984_a(), chunkscan.surfaceAvg);
        }
        blocksPerChunk += this.genStarPosition(gen, world, random, pos.func_177977_b(), chunkscan.surfaceAvg);
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(gen, world, random, pos.func_177978_c(), chunkscan.surfaceAvg);
        }
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(gen, world, random, pos.func_177968_d(), chunkscan.surfaceAvg);
        }
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(gen, world, random, pos.func_177974_f(), chunkscan.surfaceAvg);
        }
        if (random.nextFloat() < this.veinDensity.floatValue()) {
            blocksPerChunk += this.genStarPosition(gen, world, random, pos.func_177976_e(), chunkscan.surfaceAvg);
        }
        return blocksPerChunk;
    }

    private int genStarPosition(GeneratorMethods gen, World world, Random random, BlockPos pos, double surface2) throws Exception {
        int densityToSet = this.genDenseOres ? this.getDensityToSet(random, pos.func_177956_o(), surface2) : 0;
        gen.setOreBlock(new BlockPos((Vec3i)pos), this.oreBlock, densityToSet);
        return densityToSet + 1;
    }

    @Override
    public int blocksReq() {
        return (int)(12.0f * this.veinDensity.floatValue());
    }
}

