/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.oregenerators;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import wtf.ores.OreGenAbstract;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.GeneratorMethods;

public class OreGenCloud
extends OreGenAbstract {
    public final double radius;

    public OreGenCloud(IBlockState blockstate, int[] genRange, int[] minmaxPerChunk, boolean denseGen, int diameter) {
        super(blockstate, genRange, minmaxPerChunk, denseGen);
        this.radius = (float)diameter / 2.0f;
    }

    @Override
    public void doOreGen(World world, GeneratorMethods gen, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        int oriZ;
        int oriY;
        int oriX;
        int blocksReq = this.blocksReq();
        for (int blocksPerChunk = this.getBlocksPerChunk(world, coords, random, chunkscan.surfaceAvg); blocksPerChunk > blocksReq || blocksPerChunk > 0 && random.nextInt(blocksReq) < blocksPerChunk; blocksPerChunk -= this.genVein(world, gen, random, chunkscan, new BlockPos(oriX, oriY, oriZ))) {
            oriX = coords.getWorldX() + random.nextInt(16);
            oriZ = coords.getWorldZ() + random.nextInt(16);
            oriY = this.getGenStartHeight(chunkscan.surfaceAvg, random);
        }
    }

    @Override
    public int genVein(World world, GeneratorMethods gen, Random random, ChunkScan scan, BlockPos pos) throws Exception {
        int blocksSet = 0;
        int xloop = (int)(-this.radius);
        while ((double)xloop < this.radius + 1.0) {
            int yloop = (int)(-this.radius);
            while ((double)yloop < this.radius + 1.0) {
                int zloop = (int)(-this.radius);
                while ((double)zloop < this.radius + 1.0) {
                    double distance = MathHelper.func_76133_a((double)(xloop * xloop + yloop * yloop + zloop * zloop));
                    if (distance < this.radius) {
                        int densityToSet = this.genDenseOres ? this.getDensityToSet(random, pos.func_177956_o() + yloop, scan.surfaceAvg, distance, this.radius) : 0;
                        if ((double)random.nextFloat() < (double)(this.veinDensity.floatValue() / 2.0f) + (1.0 - distance / this.radius) / 2.0) {
                            blocksSet += densityToSet + 1;
                            gen.setOreBlock(new BlockPos(pos.func_177958_n() + xloop, pos.func_177956_o() + yloop, pos.func_177952_p() + zloop), this.oreBlock, densityToSet);
                        }
                    }
                    ++zloop;
                }
                ++yloop;
            }
            ++xloop;
        }
        return blocksSet;
    }

    public int getDensityToSet(Random random, double height, double surfaceAvg, double radius, double maxRadius) {
        double depth = height / (surfaceAvg * (double)this.maxGenRangeHeight);
        double radRatio = radius / maxRadius;
        double rand = random.nextFloat() + random.nextFloat() - 1.0f;
        double density = depth * 1.5 + radRatio * 1.5 + rand;
        if (density < 1.0) {
            return 0;
        }
        if (density > 2.0) {
            return 2;
        }
        return 1;
    }

    @Override
    public int blocksReq() {
        return (int)(4.188685485031271 * this.radius * this.radius * this.radius * (double)this.veinDensity.floatValue()) * 2;
    }
}

