/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores.oregenerators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.ores.OreGenAbstract;
import wtf.utilities.wrappers.CaveListWrapper;
import wtf.utilities.wrappers.CavePosition;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.GeneratorMethods;

public class OreGenCaveFloor
extends OreGenAbstract {
    private final OreGenAbstract veinType;
    private final List<surface> surfaceList;

    public OreGenCaveFloor(OreGenAbstract vein, IBlockState blockstate, int[] genRange, int[] minmaxPerChunk, boolean denseGen, ArrayList<surface> list) {
        super(blockstate, genRange, minmaxPerChunk, denseGen);
        this.veinType = vein;
        this.surfaceList = list;
    }

    @Override
    public void doOreGen(World world, GeneratorMethods gen, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        if (chunkscan.caveset.size() > 0) {
            int blocksPerChunk = this.getBlocksPerChunk(world, coords, random, chunkscan.surfaceAvg);
            int blockReqs = this.blocksReq();
            while (blocksPerChunk > blockReqs || blocksPerChunk > 0 && random.nextInt(blockReqs) < blocksPerChunk) {
                surface surfaceGen = this.surfaceList.get(random.nextInt(this.surfaceList.size()));
                BlockPos pos = null;
                CaveListWrapper cave = chunkscan.caveset.getRandomCave(random);
                CavePosition cavepos = cave.getRandomPosition(random);
                if (cavepos == null) continue;
                switch (surfaceGen) {
                    case ceiling: {
                        cavepos.getCeilingPos();
                        break;
                    }
                    case floor: {
                        pos = cavepos.getFloorPos();
                        break;
                    }
                    case wall: {
                        pos = cave.getRandomWall(random);
                        break;
                    }
                }
                if (pos == null) continue;
                blocksPerChunk -= this.veinType.genVein(world, gen, random, chunkscan, pos);
            }
        }
    }

    @Override
    public int genVein(World world, GeneratorMethods gen, Random random, ChunkScan scan, BlockPos pos) throws Exception {
        return 0;
    }

    @Override
    public int blocksReq() {
        return this.veinType.blocksReq();
    }

    public static enum surface {
        floor,
        wall,
        ceiling;

    }
}

