/*
 * Decompiled with CFR 0.152.
 */
package wtf.ores;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import wtf.config.ore.WTFOresNewConfig;
import wtf.utilities.simplex.SimplexHelper;
import wtf.utilities.wrappers.ChunkCoords;
import wtf.utilities.wrappers.ChunkScan;
import wtf.worldgen.GeneratorMethods;

public abstract class OreGenAbstract {
    public final IBlockState oreBlock;
    public HashMap<BiomeDictionary.Type, Float> biomeModifier = new HashMap();
    public HashSet<Integer> dimension = new HashSet();
    public float maxGenRangeHeight;
    public float minGenRangeHeight;
    public int maxPerChunk;
    public int minPerChunk;
    public Float veinDensity = Float.valueOf(1.0f);
    private final SimplexHelper simplex;
    public boolean genDenseOres;
    public final ArrayList<BiomeDictionary.Type> reqBiomeTypes = new ArrayList();

    public OreGenAbstract(IBlockState blockstate, int[] genRange, int[] minmaxPerChunk, boolean denseGen) {
        this.oreBlock = blockstate;
        this.maxGenRangeHeight = (float)genRange[1] / 100.0f;
        this.minGenRangeHeight = (float)genRange[0] / 100.0f;
        this.maxPerChunk = minmaxPerChunk[1];
        this.minPerChunk = minmaxPerChunk[0];
        this.genDenseOres = denseGen;
        this.simplex = new SimplexHelper(blockstate.toString());
    }

    public final void generate(World world, GeneratorMethods gen, Random random, ChunkCoords coords, ChunkScan chunkscan) throws Exception {
        if (this.dimension.contains(world.field_73011_w.getDimension())) {
            Biome biome = world.getBiomeForCoordsBody(new BlockPos(coords.getWorldX(), 100, coords.getWorldZ()));
            if (this.reqBiomeTypes.size() > 0) {
                for (BiomeDictionary.Type type : this.reqBiomeTypes) {
                    if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)type)) continue;
                    return;
                }
            }
            this.doOreGen(world, gen, random, coords, chunkscan);
        }
    }

    public abstract void doOreGen(World var1, GeneratorMethods var2, Random var3, ChunkCoords var4, ChunkScan var5) throws Exception;

    public abstract int genVein(World var1, GeneratorMethods var2, Random var3, ChunkScan var4, BlockPos var5) throws Exception;

    public abstract int blocksReq();

    protected int getBlocksPerChunk(World world, ChunkCoords coords, Random random, double surfaceAvg) {
        BiomeDictionary.Type[] biomeTypes;
        int genNum = WTFOresNewConfig.simplexGen ? (int)this.getSimplexOres(world, coords.getWorldX(), coords.getWorldZ()) : (int)(random.nextFloat() * (float)(this.maxPerChunk - this.minPerChunk) + (float)this.minPerChunk);
        for (BiomeDictionary.Type biome : biomeTypes = BiomeDictionary.getTypesForBiome((Biome)world.func_180494_b(new BlockPos((double)(coords.getWorldX() + 8), surfaceAvg, (double)(coords.getWorldZ() + 8))))) {
            if (!this.biomeModifier.containsKey(biome)) continue;
            genNum = (int)((float)genNum + (float)(this.minPerChunk + (this.maxPerChunk - this.minPerChunk) / 2) * this.biomeModifier.get(biome).floatValue());
        }
        return (int)((float)genNum * (float)surfaceAvg / (float)world.func_181545_F());
    }

    public int getGenStartHeight(double surfaceAvg, Random random) {
        int minHeight;
        int maxHeight = MathHelper.func_76141_d((float)((float)((double)this.maxGenRangeHeight * surfaceAvg)));
        int range = maxHeight - (minHeight = MathHelper.func_76141_d((float)((float)((double)this.minGenRangeHeight * surfaceAvg))));
        if (range < 1) {
            range = 1;
        }
        return random.nextInt(range) + minHeight;
    }

    public int getDensityToSet(Random random, double height, double surfaceAvg) {
        double depth = height / (surfaceAvg * (double)this.maxGenRangeHeight);
        double rand = random.nextFloat() + random.nextFloat() - 1.0f;
        double density = depth * 3.0 + rand;
        if (density < 1.0) {
            return 0;
        }
        if (density > 2.0) {
            return 2;
        }
        return 1;
    }

    public OreGenAbstract setVeinDensity(float density) {
        this.veinDensity = Float.valueOf(density);
        return this;
    }

    public double getSimplexOres(World world, double x, double z) {
        double range = this.maxPerChunk - this.minPerChunk;
        return this.simplex.get2DNoise(world, x / 8.0, z / 8.0) * range + (double)this.minPerChunk;
    }
}

