/*
 * Decompiled with CFR 0.152.
 */
package wtf.init;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import wtf.Core;
import wtf.blocks.BlockClaySlab;
import wtf.blocks.BlockCustomSlab;
import wtf.blocks.BlockDecoAnim;
import wtf.blocks.BlockDecoStatic;
import wtf.blocks.BlockFoxfire;
import wtf.blocks.BlockIcicle;
import wtf.blocks.BlockMycorrack;
import wtf.blocks.BlockNaturalSandstone;
import wtf.blocks.BlockPatchIce;
import wtf.blocks.BlockPuddle;
import wtf.blocks.BlockRedCactus;
import wtf.blocks.BlockRoots;
import wtf.blocks.BlockSpeleothem;
import wtf.blocks.GenPlaceHolder;
import wtf.blocks.OreNitre;
import wtf.config.StoneRegEntry;
import wtf.config.WTFStoneRegistry;
import wtf.gameplay.OreSandGoldNugget;
import wtf.items.ItemBlockState;
import wtf.worldgen.replacers.NetherrackReplacer;

public class WTFBlocks {
    public static HashMap<IBlockState, BlockSpeleothem> speleothemMap = new HashMap();
    public static Block oreSandGold;
    public static Block oreNitre;
    public static Block icePatch;
    public static BlockIcicle icicle;
    public static Block foxfire;
    public static BlockRoots roots;
    public static Block red_cactus;
    public static Block travelSign;
    public static Block wcicTable;
    public static Block mycorrack;
    public static Block fireLeaves;
    public static Block ubcSand;
    public static Block puddle;
    public static Block dirtSlab;
    public static Block sandSlab;
    public static Block redSandSlab;
    public static Block gravelSlab;
    public static Block mossyDirtSlab;
    public static Block claySlab;
    public static Block podzolSlab;
    public static Block genMarker;
    public static Block natSandStone;
    public static Block natRedSandStone;

    public static void initSimpleBlocks() {
        new NetherrackReplacer();
        oreNitre = WTFBlocks.registerBlock((Block)new OreNitre(), "nitre_ore");
        icePatch = WTFBlocks.registerBlock((Block)new BlockPatchIce(), "patchIce");
        icicle = (BlockIcicle)WTFBlocks.registerBlockItemSubblocks(new BlockIcicle(Blocks.field_150432_aD.func_176223_P()), 2, "icicle");
        foxfire = WTFBlocks.registerBlock((Block)new BlockFoxfire(), "foxfire");
        roots = (BlockRoots)WTFBlocks.registerBlockItemSubblocks(new BlockRoots(), 4, "roots");
        oreSandGold = WTFBlocks.registerBlock((Block)new OreSandGoldNugget(), "oreSandGold");
        natSandStone = WTFBlocks.registerBlock(new BlockNaturalSandstone(Blocks.field_150322_A.func_176223_P()), "natSandStone");
        natRedSandStone = WTFBlocks.registerBlock(new BlockNaturalSandstone(Blocks.field_180395_cM.func_176223_P()), "natRedSandStone");
        red_cactus = WTFBlocks.registerBlock((Block)new BlockRedCactus(), "red_cactus");
        mycorrack = WTFBlocks.registerBlock(new BlockMycorrack().func_149711_c(0.4f), "mycorrack");
        WTFBlocks.registerBlock(new Block(Material.field_151579_a), "base");
        puddle = WTFBlocks.registerBlock(new BlockPuddle(), "patchWater");
        dirtSlab = WTFBlocks.registerBlock((Block)new BlockCustomSlab(Blocks.field_150346_d.func_176223_P()), "slabDirt");
        sandSlab = WTFBlocks.registerBlock((Block)new BlockCustomSlab(Blocks.field_150354_m.func_176223_P()), "slabSand");
        redSandSlab = WTFBlocks.registerBlock((Block)new BlockCustomSlab(Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND)), "slabRedsand");
        gravelSlab = WTFBlocks.registerBlock((Block)new BlockCustomSlab(Blocks.field_150351_n.func_176223_P()), "slabGravel");
        mossyDirtSlab = WTFBlocks.registerBlock((Block)new BlockCustomSlab(Blocks.field_150346_d.func_176223_P()), "slabMossyDirt");
        podzolSlab = WTFBlocks.registerBlock((Block)new BlockCustomSlab(Blocks.field_150346_d.func_176223_P()), "slabPodzol");
        claySlab = WTFBlocks.registerBlock((Block)new BlockClaySlab(), "slabClay");
        genMarker = WTFBlocks.registerBlock(new GenPlaceHolder(), "genMarker");
    }

    public static void initDependentBlocks() {
        for (Map.Entry<IBlockState, StoneRegEntry> entry : WTFStoneRegistry.stoneReg.entrySet()) {
            String stoneName = entry.getKey().func_177230_c().getRegistryName().toString().split(":")[1] + entry.getKey().func_177230_c().func_176201_c(entry.getKey());
            String localisedName = StringUtils.capitalize((String)entry.getValue().textureLocation.split("/")[1].replaceAll("_", " "));
            if (entry.getValue().speleothem) {
                WTFBlocks.registerBlockItemSubblocks(new BlockSpeleothem(entry.getKey()).setFrozen(stoneName + "Speleothem"), 6, stoneName + "Speleothem");
                Core.proxy.writeSpeleothemBlockstate(entry.getKey(), stoneName + "Speleothem");
                Core.proxy.addName(stoneName + "Speleothem.0", localisedName + " Small Stalactite");
                Core.proxy.addName(stoneName + "Speleothem.1", localisedName + " Stalactite Base");
                Core.proxy.addName(stoneName + "Speleothem.2", localisedName + " Stalactite Tip");
                Core.proxy.addName(stoneName + "Speleothem.3", localisedName + " Column");
                Core.proxy.addName(stoneName + "Speleothem.4", localisedName + " Small Stalagmite");
                Core.proxy.addName(stoneName + "Speleothem.5", localisedName + " Stalagmite Base");
                Core.proxy.addName(stoneName + "Speleothem.6", localisedName + " Stalagmite Tip");
                Core.proxy.addName(stoneName + "SpeleothemFrozen.0", localisedName + " Icy Small Stalactite");
                Core.proxy.addName(stoneName + "SpeleothemFrozen.1", localisedName + " Icy Stalactite Base");
                Core.proxy.addName(stoneName + "SpeleothemFrozen.2", localisedName + " Icy Stalactite Tip");
                Core.proxy.addName(stoneName + "SpeleothemFrozen.3", localisedName + " Icy Column");
                Core.proxy.addName(stoneName + "SpeleothemFrozen.4", localisedName + " Icy Small Stalagmite");
                Core.proxy.addName(stoneName + "SpeleothemFrozen.5", localisedName + " Icy Stalagmite Base");
                Core.proxy.addName(stoneName + "SpeleothemFrozen.6", localisedName + " Icy Stalagmite Tip");
            }
            if (entry.getValue().decoAnim) {
                WTFBlocks.registerBlockItemSubblocks(new BlockDecoAnim(entry.getKey()), BlockDecoAnim.ANIMTYPE.values().length - 1, stoneName + "DecoAnim");
                Core.proxy.writeDecoAnimBlockstate(entry.getKey(), stoneName + "DecoAnim");
                Core.proxy.addName(stoneName + "DecoAnim.0", localisedName + " Lava Crust");
                Core.proxy.addName(stoneName + "DecoAnim.1", "Wet " + localisedName);
                Core.proxy.addName(stoneName + "DecoAnim.2", "Dripping Lava " + localisedName);
            }
            if (!entry.getValue().decoStatic) continue;
            WTFBlocks.registerBlockItemSubblocks(new BlockDecoStatic(entry.getKey()), BlockDecoStatic.DecoType.values().length - 1, stoneName + "DecoStatic");
            Core.proxy.writeDecoStaticBlockstate(entry.getKey(), stoneName + "DecoStatic");
            Core.proxy.addName(stoneName + "DecoStatic.0", "Mossy " + localisedName);
            Core.proxy.addName(stoneName + "DecoStatic.1", "Soul " + localisedName);
            Core.proxy.addName(stoneName + "DecoStatic.2", "Cracked " + localisedName);
        }
    }

    public static Block registerBlock(Block block, String name) {
        block.setRegistryName(name);
        block.func_149663_c(name);
        GameRegistry.register((IForgeRegistryEntry)block);
        ItemBlock temp = (ItemBlock)((Item)new ItemBlock(block).func_77655_b(name).setRegistryName(name)).func_77627_a(true);
        GameRegistry.register((IForgeRegistryEntry)temp);
        Core.proxy.registerItemRenderer(block);
        return block;
    }

    public static Block registerBlockItemSubblocks(Block block, int meta, String name) {
        block.setRegistryName(name);
        block.func_149663_c(name);
        GameRegistry.register((IForgeRegistryEntry)block);
        ItemBlock temp = (ItemBlock)((Item)new ItemBlockState(block).func_77655_b(name).setRegistryName(name)).func_77627_a(true);
        GameRegistry.register((IForgeRegistryEntry)temp);
        Core.proxy.registerItemSubblocksRenderer(block, meta);
        return block;
    }
}

