/*
 * Decompiled with CFR 0.152.
 */
package wtf.init;

import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeForest;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import wtf.config.MasterConfig;
import wtf.config.OverworldGenConfig;
import wtf.worldgen.caves.CaveTypeRegister;
import wtf.worldgen.generators.SubBiomeGenerator;
import wtf.worldgen.subbiomes.BiomeAutumnForest;
import wtf.worldgen.subbiomes.SubBiome;

public class WTFBiomes {
    public static BiomeAutumnForest autumnForest;
    public static BiomeAutumnForest autumnHills;

    public static void init() {
        System.out.println("Initialising cave biomes ");
        for (ResourceLocation location : Biome.field_185377_q.func_148742_b()) {
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)location);
            CaveTypeRegister.getCaveProfile(biome);
        }
        if (MasterConfig.enableOverworldGeneration && OverworldGenConfig.autumnForestID > 0) {
            autumnForest = new BiomeAutumnForest(BiomeForest.Type.NORMAL, new Biome.BiomeProperties("Autumn Forest").func_185410_a(0.4f).func_185395_b(0.8f), Biomes.field_76767_f);
            WTFBiomes.registerSubBiome(autumnForest, "AutumnForest", OverworldGenConfig.autumnForestID, 4);
            BiomeDictionary.registerBiomeType((Biome)autumnForest, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
            autumnHills = new BiomeAutumnForest(BiomeForest.Type.NORMAL, new Biome.BiomeProperties("Autumn Hills").func_185410_a(0.3f).func_185395_b(0.8f), Biomes.field_76785_t);
            WTFBiomes.registerSubBiome(autumnHills, "AutumnHills", OverworldGenConfig.autumnHillsID, 18);
            BiomeDictionary.registerBiomeType((Biome)autumnHills, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS});
        }
    }

    public static Biome registerSubBiome(SubBiome subbiome, String name, int id, int parentBiome) {
        Biome biome = (Biome)subbiome;
        BiomeManager.BiomeEntry entry = new BiomeManager.BiomeEntry(biome, id);
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)entry);
        BiomeManager.removeBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)entry);
        biome.setRegistryName(name);
        Biome.func_185354_a((int)id, (String)name, (Biome)biome);
        SubBiomeGenerator.subBiomeRegistry.put((byte)parentBiome, subbiome);
        return biome;
    }
}

