/*
 * Decompiled with CFR 0.152.
 */
package wtf.config.ore;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.text.WordUtils;
import wtf.Core;
import wtf.blocks.BlockDenseOre;
import wtf.blocks.BlockDenseOreFalling;
import wtf.blocks.redstone.DenseRedstoneOre;
import wtf.config.AbstractConfig;
import wtf.config.WTFStoneRegistry;
import wtf.config.ore.OreConfigHelper;
import wtf.config.ore.OreDefReg;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.ores.OreGenAbstract;
import wtf.ores.OreReplacer;
import wtf.ores.VanillOreGenCatcher;
import wtf.ores.oregenerators.OreGenCaveFloor;
import wtf.ores.oregenerators.OreGenCloud;
import wtf.ores.oregenerators.OreGenCluster;
import wtf.ores.oregenerators.OreGenSingle;
import wtf.ores.oregenerators.OreGenUnderWater;
import wtf.ores.oregenerators.OreGenVanilla;
import wtf.ores.oregenerators.OreGenVein;
import wtf.utilities.UBC.UBCOreReplacer;
import wtf.utilities.wrappers.StoneAndOre;
import wtf.worldgen.generators.OreGenerator;

public class WTFOresNewConfig
extends AbstractConfig {
    public static HashSet<IBlockState> cancelOres = new HashSet();
    public static boolean simplexGen;

    public static void loadConfig() throws Exception {
        Configuration config = new Configuration(new File("config/WTF-Expedition/WTFOresConfigV2.cfg"));
        config.load();
        simplexGen = config.get("0 General Options", "Use simplex noise instead of random for ore generation", true).getBoolean();
        String[] defOres = new String[]{"minecraft:coal_ore@0 #vein", "minecraft:iron_ore@0 #vein", "minecraft:gold_ore@0 #cloud", "minecraft:lapis_ore@0 #cluster", "minecraft:redstone_ore@0 #vein", "minecraft:emerald_ore@0 #single", "minecraft:diamond_ore@0 #single", "minecraft:quartz_ore@0 #cave&cluster", "wtfcore:nitre_ore@0 #cave&single", "wtfcore:oreSandGold@0 #underwater&single", "WTFBlockType:cracked #vein"};
        if (Loader.isModLoaded((String)"tconstruct")) {
            defOres = WTFOresNewConfig.appendArray(defOres, "tconstruct:ore@0 #vein");
            defOres = WTFOresNewConfig.appendArray(defOres, "tconstruct:ore@1 #cloud");
        }
        String[] oreSet = config.get("1 Master Ore List", "Master list of all ores generated, add ore blocks to this list, then run minecraft, in order to generate their config options", defOres).getStringList();
        HashMap<String, OreDefReg> defPresets = OreConfigHelper.getPresets();
        for (String oreGenString : oreSet) {
            String[] reqBiomes;
            int[] dimensionIDs;
            if (oreGenString.length() <= 1) continue;
            String category = "Config for " + oreGenString;
            if (!oreGenString.contains("#")) {
                config.get(category, "Generation type missing", "please delete this entry, and include a generation type in the master config string for " + oreGenString);
                continue;
            }
            String oreString = oreGenString.split("#")[0].replaceAll("\\s", "");
            String genString = oreGenString.split("#")[1].replaceAll("\\s", "");
            if (oreString == " wtfcore:stone0DecoStatic@2") {
                oreString = "WTFBlockType:cracked #vein";
            }
            IBlockState oreState = null;
            BlockSets.Modifier modifier = null;
            if (oreString.toLowerCase().contains("wtfblocktype")) {
                try {
                    modifier = BlockSets.Modifier.valueOf(oreString.split(":")[1].toUpperCase());
                    oreState = BlockSets.getTransformedState(Blocks.field_150348_b.func_176223_P(), modifier);
                }
                catch (IllegalArgumentException e) {
                    BlockSets.Modifier[] types = BlockSets.Modifier.values();
                    String gentypestring = "";
                    for (BlockSets.Modifier type : types) {
                        gentypestring = gentypestring + "WTFBlockType:" + type.toString() + ", ";
                    }
                    throw new Exception("Ore Config Parsing Exception while trying to parse config for " + oreString + " ***** " + oreString + " is not a recognised block modifier type.  Accepted Block modifier types are: " + gentypestring);
                }
            } else {
                oreState = WTFOresNewConfig.getBlockState(oreString);
            }
            if (oreState == null) {
                config.get(category, "Block not found", "unable to find block for " + oreGenString);
                break;
            }
            cancelOres.add(oreState);
            OreDefReg preset = defPresets.get(oreString);
            if (preset == null) {
                preset = defPresets.get("minecraft:iron_ore@0");
            }
            String stoneStringList = config.get(category, "0 List of background stones", preset.stoneList).getString().replaceAll("\\s", "");
            ArrayList<IBlockState> stoneArray = WTFOresNewConfig.getBlockStateArray(stoneStringList);
            int[] genRange = config.get(category, "2 Generation height range (min % surface height, max % surface height)", preset.genRange).getIntList();
            try {
                if (genRange[1] - genRange[0] < 1) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new Exception("Ore Config Parsing Exception while trying to parse  : " + oreString + " ***** Generation height range is not valid, max range must be greater than min range");
            }
            int[] orePerChunk = config.get(category, "1 Amount of ore to attempt to generate per chunk (min, max)", preset.orePerChunk).getIntList();
            boolean denseBlock = config.get(category, "4 Use dense versions of this ore block", modifier == null ? preset.denseBlock : false).getBoolean();
            String defRegName = modifier == null ? oreString.split(":")[1].split("@")[0] + oreString.split("@")[1] : oreString.split(":")[1];
            String oreBlockName = config.get(category, "0 Block Registry Name (changing this will break existing worlds)", defRegName).getString();
            OreGenAbstract generator = WTFOresNewConfig.getGenerator(oreGenString, preset, config, genString, oreState, genRange, orePerChunk, denseBlock);
            String textureLoc = config.get(category, "5 Ore texture", preset.textureLoc == null ? oreState.func_177230_c().getRegistryName().toString().split(":")[1] : preset.textureLoc).getString();
            int[] overworld = new int[]{0};
            for (int ID : dimensionIDs = config.get(category, "3 Dimensions to spawn in", preset.dimensionIDs == null ? overworld : preset.dimensionIDs).getIntList()) {
                generator.dimension.add(ID);
            }
            float density = (float)config.get(category, "6 Vein percent density (chance each block will generate or not)", preset.density).getInt() / 100.0f;
            generator.setVeinDensity(density);
            String[] biomeModTags = config.get(category, "7 Percent ore generation in biome type", preset.biomeTags).getString().replaceAll("\\s", "").toLowerCase().split(",");
            generator.biomeModifier = new HashMap();
            if (biomeModTags[0] != "" && biomeModTags.length > 0) {
                for (String biomestring : biomeModTags) {
                    if (biomestring.length() <= 0) continue;
                    float f = (float)Integer.parseInt(biomestring.split("@")[1]) / 100.0f;
                    generator.biomeModifier.put(WTFOresNewConfig.getBiomeTypeFromString(biomestring.split("@")[0]), Float.valueOf(f));
                }
            }
            if ((reqBiomes = config.get(category, "8 Required Biome types", preset.reqBiomeTypes == null ? "" : preset.reqBiomeTypes).getString().replaceAll("\\s", "").toLowerCase().split(","))[0] != "" && reqBiomes.length > 0) {
                for (String biomestring : reqBiomes) {
                    if (biomestring.length() <= 0) continue;
                    generator.reqBiomeTypes.add(WTFOresNewConfig.getBiomeTypeFromString(biomestring));
                }
            }
            for (IBlockState stone : stoneArray) {
                if (modifier != null) {
                    BlockSets.stoneAndOre.put(new StoneAndOre(stone, oreState), BlockSets.getTransformedState(stone, modifier));
                }
                if (denseBlock) {
                    Block block;
                    Block stoneblock = stone.func_177230_c();
                    int meta = stoneblock.func_176201_c(stone);
                    String stoneName = stoneblock.getRegistryName().toString().split(":")[1] + meta;
                    String regName = "dense_" + stoneName + oreBlockName;
                    String locStoneName = WordUtils.capitalize((String)WTFStoneRegistry.stoneReg.get((Object)stone).textureLocation.split("/")[1].replaceAll("_", " "));
                    String locOreName = WordUtils.capitalize((String)textureLoc.replaceAll("_", " "));
                    if (oreState.func_177230_c() != Blocks.field_150450_ax) {
                        if (stone.func_177230_c() instanceof BlockFalling) {
                            block = WTFBlocks.registerBlock((Block)new BlockDenseOreFalling(stone, oreState), regName);
                            Core.proxy.writeDenseOreBlockstate(stone, regName, textureLoc, stoneName);
                            Core.proxy.addName(regName, "Dense " + locStoneName + " " + locOreName);
                        } else {
                            block = WTFBlocks.registerBlock(new BlockDenseOre(stone, oreState), regName);
                            Core.proxy.writeDenseOreBlockstate(stone, regName, textureLoc, stoneName);
                            Core.proxy.addName(regName, "Dense " + locStoneName + " " + locOreName);
                        }
                    } else {
                        block = WTFBlocks.registerBlock(new DenseRedstoneOre(false), regName);
                        Core.proxy.writeDenseOreBlockstate(stone, regName, textureLoc, stoneName);
                        Core.proxy.addName(regName, "Dense " + locStoneName + " " + locOreName);
                        DenseRedstoneOre.denseRedstone_off = block;
                        DenseRedstoneOre.denseRedstone_on = WTFBlocks.registerBlock(new DenseRedstoneOre(true), regName + "_on");
                        Core.proxy.writeDenseOreBlockstate(stone, regName + "_on", textureLoc, stoneName);
                        Core.proxy.addName(regName + "_on", "Dense " + locStoneName + " " + locOreName);
                    }
                    BlockSets.stoneAndOre.put(new StoneAndOre(stone, oreState), block.func_176223_P());
                    continue;
                }
                if (modifier != null) continue;
                BlockSets.stoneAndOre.put(new StoneAndOre(stone, oreState), oreState);
                if (Core.UBC) {
                    new UBCOreReplacer(oreState.func_177230_c());
                    continue;
                }
                new OreReplacer(oreState.func_177230_c());
            }
            OreGenerator.oreGenRegister.add(generator);
            VanillOreGenCatcher.vanillaCanceler(oreState);
            Core.coreLog.info("Ore Generator Added for " + oreGenString);
        }
        config.save();
    }

    public static OreGenAbstract getGenerator(String oreString, OreDefReg preset, Configuration config, String genString, IBlockState oreState, int[] genRange, int[] orePerChunk, boolean denseBlock) throws Exception {
        GENTYPE gentype;
        String[] genTypeArray = genString.split("&");
        try {
            gentype = GENTYPE.valueOf(genTypeArray[0].toLowerCase());
        }
        catch (IllegalArgumentException e) {
            GENTYPE[] types = GENTYPE.values();
            String gentypestring = "";
            for (GENTYPE type : types) {
                gentypestring = gentypestring + type.toString() + ", ";
            }
            throw new Exception("Ore Config Parsing Exception while trying to parse config for " + oreString + " ***** " + genString + " is not a recognised generation type.  Accepted generation types are: " + gentypestring);
        }
        OreGenAbstract secondaryGen = null;
        switch (gentype) {
            case cave: {
                String[] surfacestrings;
                ArrayList<OreGenCaveFloor.surface> surfacelist = new ArrayList<OreGenCaveFloor.surface>();
                for (String string : surfacestrings = config.get("Config for " + oreString, "Surfaces in which to generates: floor, ceiling, wall, seperated by a &", preset.surfaces).getString().replaceAll("\\s", "").split("&")) {
                    try {
                        surfacelist.add(OreGenCaveFloor.surface.valueOf(string.toLowerCase()));
                    }
                    catch (IllegalArgumentException e) {
                        OreGenCaveFloor.surface[] types = OreGenCaveFloor.surface.values();
                        String gentypestring = "";
                        for (OreGenCaveFloor.surface type : types) {
                            gentypestring = gentypestring + type.toString() + ", ";
                        }
                        throw new Exception("Ore Config Parsing Exception while trying to parse  : " + oreString + " ***** " + string + " is not a recognised surface type.  Accepted surface types are: " + gentypestring);
                    }
                }
                secondaryGen = WTFOresNewConfig.getGenerator(oreString, preset, config, genTypeArray[1], oreState, genRange, orePerChunk, denseBlock);
                return new OreGenCaveFloor(secondaryGen, oreState, genRange, orePerChunk, denseBlock, surfacelist);
            }
            case cloud: {
                int cloudDiameter = config.get("Config for " + oreString, "Cloud diameter", preset.cloudDiameter).getInt();
                return new OreGenCloud(oreState, genRange, orePerChunk, denseBlock, cloudDiameter);
            }
            case cluster: {
                return new OreGenCluster(oreState, genRange, orePerChunk, denseBlock);
            }
            case single: {
                return new OreGenSingle(oreState, genRange, orePerChunk, denseBlock);
            }
            case underwater: {
                secondaryGen = WTFOresNewConfig.getGenerator("Config for " + oreString, preset, config, genTypeArray[1], oreState, genRange, orePerChunk, denseBlock);
                return new OreGenUnderWater(secondaryGen, oreState, genRange, orePerChunk, denseBlock);
            }
            case vanilla: {
                int blocksPerCluster = config.get("Config for " + oreString, "Blocks per cluster", preset.vanillaBlocksPerCluster).getInt();
                return new OreGenVanilla(oreState, genRange, orePerChunk, denseBlock, blocksPerCluster);
            }
            case vein: {
                int[] dimensions = config.get("Config for " + oreString, "Vein dimensions (length,width,vertical thickness)", preset.veinDimensions).getIntList();
                float pitch = (float)config.get("Config for " + oreString, "Average vein pitch (o for horizontal, 1.5 for vertical)", (double)preset.veinPitch).getDouble();
                return new OreGenVein(oreState, genRange, orePerChunk, dimensions, pitch, denseBlock);
            }
        }
        return null;
    }

    public static enum GENTYPE {
        vanilla,
        vein,
        cloud,
        cluster,
        single,
        cave,
        underwater;

    }
}

