/*
 * Decompiled with CFR 0.152.
 */
package wtf.config;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import wtf.Core;
import wtf.config.AbstractConfig;
import wtf.config.StoneRegEntry;
import wtf.init.BlockSets;
import wtf.init.WTFBlocks;
import wtf.utilities.UBC.UBCCompat;
import wtf.utilities.wrappers.StateAndModifier;

public class WTFStoneRegistry
extends AbstractConfig {
    static Random rand = new Random();
    public static Configuration config = new Configuration(new File("config/WTF-Expedition/WTFStoneRegistry.cfg"));
    public static HashMap<IBlockState, String> defBlockStateLocations = new HashMap();
    public static HashMap<IBlockState, String> defTextureLocations = new HashMap();
    public static HashMap<IBlockState, String> defCobble = new HashMap();
    public static HashMap<Block, Integer> defSpeed = new HashMap();
    public static HashMap<IBlockState, StoneRegEntry> stoneReg = new HashMap();

    public static void loadOverrideMap() {
        defBlockStateLocations.put(Blocks.field_150348_b.func_176223_P(), "stone#normal");
        defBlockStateLocations.put(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), "andesite#normal");
        defBlockStateLocations.put(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), "diorite#normal");
        defBlockStateLocations.put(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), "granite#normal");
        defBlockStateLocations.put(Blocks.field_150354_m.func_176223_P(), "sand#normal");
        defBlockStateLocations.put(Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND), "red_sand#normal");
        defBlockStateLocations.put(WTFBlocks.natSandStone.func_176223_P(), "sandstone#normal");
        defBlockStateLocations.put(WTFBlocks.natRedSandStone.func_176223_P(), "red_sandstone#normal");
        defBlockStateLocations.put(Blocks.field_150346_d.func_176223_P(), "dirt#normal");
        defBlockStateLocations.put(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT), "coarse_dirt#normal");
        defBlockStateLocations.put(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL), "podzol#normal");
        defBlockStateLocations.put(Blocks.field_150343_Z.func_176223_P(), "obsidian#normal");
        defBlockStateLocations.put(Blocks.field_150351_n.func_176223_P(), "gravel#normal");
        defBlockStateLocations.put(Blocks.field_150424_aL.func_176223_P(), "netherrack#normal");
        defTextureLocations.put(Blocks.field_150348_b.func_176223_P(), "minecraft:blocks/stone");
        defTextureLocations.put(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), "minecraft:blocks/stone_andesite");
        defTextureLocations.put(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), "minecraft:blocks/stone_diorite");
        defTextureLocations.put(Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), "minecraft:blocks/stone_granite");
        defTextureLocations.put(Blocks.field_150354_m.func_176223_P(), "minecraft:blocks/sand");
        defTextureLocations.put(Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND), "minecraft:blocks/red_sand");
        defTextureLocations.put(WTFBlocks.natSandStone.func_176223_P(), "minecraft:blocks/sandstone_top");
        defTextureLocations.put(WTFBlocks.natRedSandStone.func_176223_P(), "minecraft:blocks/red_sandstone_top");
        defTextureLocations.put(Blocks.field_150346_d.func_176223_P(), "minecraft:blocks/dirt");
        defTextureLocations.put(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT), "minecraft:blocks/coarse_dirt");
        defTextureLocations.put(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL), "minecraft:blocks/podzol");
        defTextureLocations.put(Blocks.field_150343_Z.func_176223_P(), "minecraft:blocks/obsidian");
        defTextureLocations.put(Blocks.field_150351_n.func_176223_P(), "minecraft:blocks/gravel");
        defTextureLocations.put(Blocks.field_150424_aL.func_176223_P(), "minecraft:blocks/netherrack");
        defCobble.put(WTFBlocks.natSandStone.func_176223_P(), "minecraft:sand@0");
        defCobble.put(WTFBlocks.natRedSandStone.func_176223_P(), "minecraft:sand@1");
        defSpeed.put(Blocks.field_150348_b, 15);
        defSpeed.put(WTFBlocks.natSandStone, 30);
        defSpeed.put(WTFBlocks.natRedSandStone, 30);
        if (Core.UBC) {
            defSpeed.put(UBCCompat.IgneousStone[0].func_177230_c(), 5);
            defSpeed.put(UBCCompat.MetamorphicStone[0].func_177230_c(), 20);
            defSpeed.put(UBCCompat.SedimentaryStone[0].func_177230_c(), 30);
        }
    }

    public static void loadStoneReg() throws Exception {
        WTFStoneRegistry.loadOverrideMap();
        config.load();
        String[] defstone = new String[]{"minecraft:stone@0", "minecraft:stone@1", "minecraft:stone@3", "minecraft:stone@5", "wtfcore:natSandStone@0", "wtfcore:natRedSandStone@0", "minecraft:obsidian@0", "minecraft:dirt@0", "minecraft:sand@0", "minecraft:sand@1", "minecraft:gravel@0", "minecraft:netherrack@0"};
        if (Core.UBC) {
            for (String string : UBCCompat.UBCStoneList) {
                defstone = WTFStoneRegistry.appendArray(defstone, string);
            }
        }
        String[] stoneset = config.get("Master Stone List", "Master list of stone blockstates", defstone).getStringList();
        TreeSet<String> stoneTreeSet = new TreeSet<String>(Arrays.asList(stoneset));
        for (String stateString : stoneTreeSet) {
            IBlockState state = WTFStoneRegistry.getBlockState(stateString);
            if (state != null) {
                String locBlockstate = config.get(stateString, "BlockState resource location", defBlockStateLocations.get(state) == null ? state.func_177230_c().getRegistryName().toString() : defBlockStateLocations.get(state).toString()).getString();
                String locTexture = config.get(stateString, "Stone texture resource location", defTextureLocations.get(state) == null ? "null" : defTextureLocations.get(state).toString()).getString();
                String cobblestring = defCobble.get(state);
                if (cobblestring == null) {
                    Block drop = Block.func_149634_a((Item)state.func_177230_c().func_180660_a(state, rand, 0));
                    int meta = state.func_177230_c().func_180651_a(state);
                    cobblestring = drop != null && drop != state.func_177230_c() ? drop.getRegistryName() + "@" + meta : "";
                }
                cobblestring = config.get(stateString, "Cobblestone version of block", cobblestring).getString();
                IBlockState cobblestone = WTFStoneRegistry.getBlockState(cobblestring);
                boolean speleothems = config.get(stateString, "Generate stalactite and stalagmites", state.func_185904_a() == Material.field_151576_e && !state.func_177230_c().getRegistryName().toString().contains("cobble")).getBoolean();
                boolean staticDeco = config.get(stateString, "Generate static deco blocks (moss, cracked, ect)", true).getBoolean();
                boolean animDeco = config.get(stateString, "Generate animated deco blocks (Lava crust, dripping, ect)", state.func_185904_a() == Material.field_151576_e).getBoolean();
                boolean cracked = config.get(stateString, "Allow cracked version to spawn in world (requires static deco blocks, and cracked stone ore generation)", state.func_185904_a() == Material.field_151576_e && !state.func_177230_c().getRegistryName().toString().contains("cobble")).getBoolean();
                boolean frac = false;
                if (Loader.isModLoaded((String)"wtfgameplay")) {
                    int speed = config.get(stateString, "Gameplay: Percentage speed modifier to mine (100% disables)", defSpeed.get(state.func_177230_c()) != null ? defSpeed.get(state.func_177230_c()) : 100).getInt();
                    BlockSets.blockMiningSpeed.put(state, Float.valueOf((float)speed / 100.0f));
                    if (cobblestone != null) {
                        frac = config.get(stateString, "Gameplay: Fractures into cobblestone variant before breaking", true).getBoolean();
                        BlockSets.blockTransformer.put(new StateAndModifier(state, BlockSets.Modifier.COBBLE), cobblestone);
                    }
                }
                stoneReg.put(state, new StoneRegEntry(state, cobblestone, locTexture, locBlockstate, staticDeco, animDeco, speleothems, cracked, frac));
                continue;
            }
            config.get(stateString, "unable to find Block", "").getString();
        }
        config.save();
    }
}

