/*
 * Decompiled with CFR 0.152.
 */
package wtf.config;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.BiomeDictionary;
import wtf.utilities.UBC.UBCCompat;

public abstract class AbstractConfig {
    protected static final String configPath = "config/WTF-Expedition/";

    public static BiomeDictionary.Type getBiomeTypeFromString(String biomestring) throws Exception {
        try {
            return BiomeDictionary.Type.valueOf((String)biomestring.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            BiomeDictionary.Type[] types = BiomeDictionary.Type.values();
            String string = "";
            for (BiomeDictionary.Type type : types) {
                string = string + type.toString() + ", ";
            }
            throw new Exception("Ore Config Parsing Exception while trying to parse Biome Percent modifier : " + biomestring + ":  Unrecognised Forge BiomeDictionary BiomeType, the available biome types are : " + string);
        }
    }

    public static Block getBlockFromString(String string) {
        Block block = Block.func_149684_b((String)string);
        if (block == null) {
            try {
                throw new NoBlockRegistryFoundForStringException("Unable to find block for " + string);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return block;
    }

    public static IBlockState getBlockState(String string) {
        IBlockState state;
        if (string == null || !string.contains("@")) {
            return null;
        }
        String[] stringArray = string.split("@");
        Block block = Block.func_149684_b((String)stringArray[0]);
        if (block == null) {
            try {
                throw new NoBlockRegistryFoundForStringException("Unable to find block for " + stringArray[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stringArray.length < 1) {
            try {
                throw new Exception("Unable to find metadata argument for :" + string + ".");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((state = block.func_176203_a(Integer.parseInt(stringArray[1]))) == null) {
            try {
                throw new Exception("Invalid blockstate for block and meta " + string);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return state;
    }

    public static ArrayList<IBlockState> getBlockStateArray(String string) {
        String[] stringArray;
        ArrayList<IBlockState> list = new ArrayList<IBlockState>();
        for (String substring : stringArray = string.split(",")) {
            if (substring.equals("igneous")) {
                list.addAll(Arrays.asList(UBCCompat.IgneousStone));
                continue;
            }
            if (substring.equals("metamorphic")) {
                list.addAll(Arrays.asList(UBCCompat.MetamorphicStone));
                continue;
            }
            if (substring.equals("sedimentary")) {
                list.addAll(Arrays.asList(UBCCompat.SedimentaryStone));
                continue;
            }
            list.add(AbstractConfig.getBlockState(substring));
        }
        return list;
    }

    protected static String[] appendArray(String[] arrayString, String stringToAdd) {
        String[] newStringArray = new String[arrayString.length + 1];
        for (int loop = 0; loop < arrayString.length; ++loop) {
            newStringArray[loop] = arrayString[loop];
        }
        newStringArray[newStringArray.length - 1] = stringToAdd;
        return newStringArray;
    }

    public static class NoBlockRegistryFoundForStringException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NoBlockRegistryFoundForStringException(String string) {
            super(string);
        }
    }
}

