/*
 * Decompiled with CFR 0.152.
 */
package wtf.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wtf.blocks.AbstractBlockDerivative;

public class BlockRoots
extends AbstractBlockDerivative {
    public static final IProperty<RootType> TYPE = PropertyEnum.func_177709_a((String)"type", RootType.class);

    public BlockRoots() {
        super(Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)RootType.oak)));
    }

    @Override
    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            List<ItemStack> items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
            for (ItemStack item : items) {
                if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
                BlockRoots.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151055_y;
    }

    public int func_149745_a(Random random) {
        return 1 + random.nextInt(2);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)RootType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        RootType type = (RootType)((Object)state.func_177229_b(TYPE));
        return type.getID();
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int loop = 0; loop < RootType.values().length; ++loop) {
            list.add(new ItemStack(itemIn, 1, loop));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static enum RootType implements IStringSerializable
    {
        oak(0, "oak"),
        spruce(1, "spruce"),
        birch(2, "birch"),
        jungle(3, "jungle"),
        big_oak(4, "big_oak"),
        acacia(5, "acacia");

        private final int ID;
        private final String name;

        private RootType(int ID, String name) {
            this.ID = ID;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

