/*
 * Decompiled with CFR 0.152.
 */
package wtf.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import wtf.blocks.AbstractBlockDerivativeFalling;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.StoneAndOre;

public class BlockDenseOreFalling
extends AbstractBlockDerivativeFalling {
    public static final PropertyInteger DENSITY = PropertyInteger.func_177719_a((String)"density", (int)0, (int)2);

    public BlockDenseOreFalling(IBlockState backState, IBlockState foreState) {
        super(backState, foreState);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DENSITY, (Comparable)Integer.valueOf(0)));
        BlockSets.stoneAndOre.put(new StoneAndOre(backState, foreState), this.func_176223_P());
        BlockSets.oreAndFractures.add((Block)this);
        this.func_149649_H();
        BlockSets.surfaceBlocks.add((Block)this);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        switch (layer) {
            case CUTOUT: {
                return false;
            }
            case CUTOUT_MIPPED: {
                return false;
            }
            case SOLID: {
                return true;
            }
            case TRANSLUCENT: {
                return true;
            }
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.field_176227_L.func_177621_b().func_177226_a((IProperty)DENSITY, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DENSITY);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        state = (Integer)state.func_177229_b((IProperty)DENSITY) < 2 ? state.func_177226_a((IProperty)DENSITY, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)DENSITY) + 1)) : Blocks.field_150350_a.func_176223_P();
        player.func_71029_a(StatList.func_188055_a((Block)this.parentForeground.func_177230_c()));
        return world.func_180501_a(pos, state, world.field_72995_K ? 11 : 3);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DENSITY});
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return this.parentForeground.func_177230_c().canSilkHarvest(world, pos, state, player);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = new ItemStack(this.parentForeground.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            if (itemstack != null) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                BlockDenseOreFalling.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            this.func_176226_b(worldIn, pos, state, i);
            this.harvesters.set(null);
        }
    }
}

