/*
 * Decompiled with CFR 0.152.
 */
package wtf.blocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import wtf.blocks.AbstractBlockDerivative;
import wtf.entities.IUtilityEntity;
import wtf.init.BlockSets;
import wtf.utilities.wrappers.StateAndModifier;

public class BlockDecoStatic
extends AbstractBlockDerivative {
    public static final IProperty<DecoType> TYPE = PropertyEnum.func_177709_a((String)"type", DecoType.class);
    public static ArrayList<BlockDecoStatic> crackedList = new ArrayList();
    public static IUtilityEntity cracker;

    public BlockDecoStatic(IBlockState state) {
        super(state, state);
        if (state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151578_c) {
            IBlockState mossyCobble;
            BlockSets.blockTransformer.put(new StateAndModifier(state, BlockSets.Modifier.MOSSY), this.func_176223_P());
            IBlockState cobble = BlockSets.getTransformedState(state, BlockSets.Modifier.COBBLE);
            if (cobble != null && (mossyCobble = BlockSets.getTransformedState(cobble, BlockSets.Modifier.MOSSY)) != null) {
                BlockSets.blockTransformer.put(new StateAndModifier(this.func_176223_P(), BlockSets.Modifier.COBBLE), mossyCobble);
            }
        }
        BlockSets.blockTransformer.put(new StateAndModifier(state, BlockSets.Modifier.SOUL), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)DecoType.SOUL)));
        if (state.func_185904_a() == Material.field_151576_e || state.func_185904_a() == Material.field_151588_w) {
            BlockSets.blockTransformer.put(new StateAndModifier(state, BlockSets.Modifier.CRACKED), this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)DecoType.CRACKED)));
        }
        if (BlockSets.fallingBlocks.containsKey(this.parentBackground)) {
            BlockSets.fallingBlocks.put(this, BlockSets.fallingBlocks.get(this.parentBackground));
        }
        if (BlockSets.fallingBlocks.containsKey(state.func_177230_c())) {
            BlockSets.fallingBlocks.put(this, BlockSets.fallingBlocks.get(state.func_177230_c()));
        }
        BlockSets.ReplaceHashset.add(this);
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (cracker != null && !world.field_72995_K && state.func_177229_b(TYPE) == DecoType.CRACKED) {
            cracker.doEvent(world, pos);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        switch (layer) {
            case CUTOUT: {
                return false;
            }
            case CUTOUT_MIPPED: {
                return false;
            }
            case SOLID: {
                return true;
            }
            case TRANSLUCENT: {
                return true;
            }
        }
        return false;
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int loop = 0; loop < DecoType.values().length; ++loop) {
            list.add(new ItemStack(itemIn, 1, loop));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)DecoType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((DecoType)((Object)state.func_177229_b(TYPE))).ID;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum DecoType implements IStringSerializable
    {
        MOSS(0, "moss", BlockSets.Modifier.MOSSY),
        SOUL(1, "soul", BlockSets.Modifier.SOUL),
        CRACKED(2, "cracked", BlockSets.Modifier.CRACKED);

        private final int ID;
        private final String name;
        public final BlockSets.Modifier modifier;

        private DecoType(int ID, String name, BlockSets.Modifier mod) {
            this.ID = ID;
            this.name = name;
            this.modifier = mod;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getID() {
            return this.ID;
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

