/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.knobcontrol.util;

import com.kashdeya.knobcontrol.handlers.ModularsHandler;
import com.kashdeya.knobcontrol.handlers.ServerHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Server {
    public static boolean setSpawnDay;
    Random rand = new Random();

    @SubscribeEvent
    public void hardcoreEvent(LivingHurtEvent event) {
        if (ModularsHandler.hardcore) {
            if (ServerHandler.airOff && event.getSource().equals(DamageSource.field_76369_e)) {
                event.setAmount(Float.MAX_VALUE);
            }
            if (ServerHandler.CactusHurts && event.getSource().equals(DamageSource.field_76367_g)) {
                event.setAmount(Float.MAX_VALUE);
            }
            if (ServerHandler.dragonBreath && event.getSource().equals(DamageSource.field_188407_q)) {
                event.setAmount(Float.MAX_VALUE);
            }
            if (ServerHandler.FallDamage && event.getSource().equals(DamageSource.field_76379_h)) {
                event.setAmount(Float.MAX_VALUE);
            }
            if (ServerHandler.FallingBlock && event.getSource().equals(DamageSource.field_82729_p)) {
                event.setAmount(Float.MAX_VALUE);
            }
            if (ServerHandler.FoodOverhaul && event.getSource().equals(DamageSource.field_76366_f)) {
                event.setAmount(Float.MAX_VALUE);
            }
            if (ServerHandler.LavaHurts && event.getSource().equals(DamageSource.field_76371_c)) {
                event.setAmount(Float.MAX_VALUE);
            }
            if (ServerHandler.witherDeath && event.getSource().equals(DamageSource.field_82727_n)) {
                event.setAmount(Float.MAX_VALUE);
            }
            if (ServerHandler.inFire && event.getSource().equals(DamageSource.field_76372_a)) {
                event.setAmount(Float.MAX_VALUE);
            }
            if (ServerHandler.onFire && event.getSource().equals(DamageSource.field_76370_b)) {
                event.setAmount(Float.MAX_VALUE);
            }
            if (ServerHandler.inWall && event.getSource().equals(DamageSource.field_76368_d)) {
                event.setAmount(0.0f);
            }
            if (ServerHandler.Lightning && event.getSource().equals(DamageSource.field_180137_b)) {
                event.setAmount(Float.MAX_VALUE);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        if (ServerHandler.noSleep) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
            World world = event.getEntityPlayer().func_130014_f_();
            if (world.field_73011_w.func_76567_e() && world.field_73011_w.getBiomeForCoords(event.getPos()) != Biomes.field_76778_j) {
                EntityPlayer entityPlayer = event.getEntityPlayer();
                entityPlayer.func_180473_a(event.getPos(), false);
                entityPlayer.setSpawnChunk(event.getPos(), false, event.getEntityPlayer().field_71093_bK);
                entityPlayer.func_146105_b((ITextComponent)new TextComponentTranslation("Spawn has been Set!", new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent event) {
        HashSet poisonedEntities;
        if (ServerHandler.spidersApplySlowness) {
            poisonedEntities = new HashSet();
            if (event.getSource().func_76355_l().equals("mob") && event.getSource().func_76346_g() instanceof EntitySpider && poisonedEntities.contains(event.getEntityLiving())) {
                event.getEntityLiving().func_184589_d(MobEffects.field_76436_u);
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, ServerHandler.slownessTicks * 20, ServerHandler.slownessLevel));
                poisonedEntities.remove(event.getEntityLiving());
            }
        }
        if (ServerHandler.CaveSpiderPoison) {
            poisonedEntities = new HashSet();
            if (event.getSource().func_76355_l().equals("mob") && event.getSource().func_76346_g() instanceof EntityCaveSpider && poisonedEntities.contains(event.getEntityLiving())) {
                event.getEntityLiving().func_184589_d(MobEffects.field_76436_u);
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76437_t, ServerHandler.weaknessTicks * 20, ServerHandler.weaknessLevel));
                poisonedEntities.remove(event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent
    public void interact(PlayerInteractEvent.EntityInteractSpecific entityInteractEvent) {
        if (ServerHandler.villagerTrading && entityInteractEvent.getTarget() instanceof EntityVillager) {
            entityInteractEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void harvest(BlockEvent.HarvestDropsEvent event) {
        if (ServerHandler.melonDrop) {
            if (event.getState().func_177230_c().equals(Blocks.field_150440_ba)) {
                event.getDrops().clear();
                event.getDrops().add(new ItemStack(Blocks.field_150440_ba, 1));
            }
            ItemStack block = new ItemStack(Blocks.field_150440_ba, 1);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151127_ba, 4), (Object[])new Object[]{block});
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (ServerHandler.passThrough) {
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            Block block = state.func_177230_c();
            EnumFacing facing = EnumFacing.func_82600_a((int)state.func_177230_c().func_176201_c(state)).func_176734_d();
            if (block == Blocks.field_150444_as) {
                ItemStack held = event.getEntityPlayer().func_184586_b(event.getHand());
                if (held != null && held.func_77973_b() instanceof ItemBlock) {
                    event.setUseItem(Event.Result.DENY);
                }
                if (!event.getEntityPlayer().func_70093_af()) {
                    BlockPos posOffset = new BlockPos(event.getPos().func_177958_n() + facing.func_82601_c(), event.getPos().func_177956_o() + facing.func_96559_d(), event.getPos().func_177952_p() + facing.func_82599_e());
                    Block attached = event.getWorld().func_180495_p(posOffset).func_177230_c();
                    if (!attached.isAir(state, (IBlockAccess)event.getWorld(), posOffset)) {
                        attached.func_180639_a(event.getWorld(), posOffset, event.getWorld().func_180495_p(posOffset), event.getEntityPlayer(), event.getHand(), held, event.getFace(), 0.0f, 0.0f, 0.0f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onAttacked(LivingAttackEvent event) {
        Entity attacker;
        if (ServerHandler.safeOff && event.getSource() != null && (attacker = event.getSource().func_76346_g()) != null && attacker.func_184187_bx() == event.getEntity()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void notifyNeighbors(BlockEvent.NeighborNotifyEvent event) {
        if (ServerHandler.leafDecay) {
            for (EnumFacing facing : event.getNotifiedSides()) {
                IBlockState state;
                BlockPos pos = event.getPos().func_177972_a(facing);
                if (!event.getWorld().func_175667_e(pos) || !(state = event.getWorld().func_180495_p(pos)).func_177230_c().isLeaves(state, (IBlockAccess)event.getWorld(), pos)) continue;
                event.getWorld().func_175684_a(pos, state.func_177230_c(), ServerHandler.DecaySpeed + (ServerHandler.DecayFuzz > 0 ? this.rand.nextInt(ServerHandler.DecayFuzz) : 0));
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (ServerHandler.NoSwim && event.getEntity() instanceof EntityPlayer && event.getEntity().field_70170_p.field_72995_K && event.getEntity().func_70090_H() && GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74314_A)) {
            event.getEntity().field_70181_x -= 0.03;
        }
        if (ServerHandler.featherDrops) {
            if (event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof EntityChicken)) {
                return;
            }
            EntityChicken chicken = (EntityChicken)event.getEntity();
            if (chicken.func_70631_g_() && ServerHandler.chicksDropFeathers) {
                return;
            }
            if (chicken.field_70170_p.field_73012_v.nextInt(ServerHandler.dropFreq) == 1) {
                chicken.func_145779_a(Items.field_151008_G, 1);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (ServerHandler.featherDrops) {
            boolean setFeather = false;
            if (event.getEntity().field_70170_p.field_72995_K || ServerHandler.forceFeatherDrop || !(event.getEntity() instanceof EntityChicken) || !((EntityChicken)event.getEntity()).func_70631_g_() && ServerHandler.chicksDropFeathers) {
                return;
            }
            EntityChicken chicken = (EntityChicken)event.getEntity();
            for (EntityItem item : event.getDrops()) {
                if (item == null || !item.func_92059_d().func_77973_b().equals(Items.field_151008_G)) continue;
                setFeather = true;
                item.func_92059_d().field_77994_a = MathHelper.func_76136_a((Random)item.field_70170_p.field_73012_v, (int)1, (int)2);
            }
            if (!setFeather) {
                event.getDrops().add(new EntityItem(event.getEntity().field_70170_p, chicken.field_70165_t, chicken.field_70163_u, chicken.field_70161_v, new ItemStack(Items.field_151008_G, MathHelper.func_76136_a((Random)event.getEntity().field_70170_p.field_73012_v, (int)1, (int)2))));
            }
        }
    }

    @SubscribeEvent
    public void sleephunger(PlayerWakeUpEvent event) {
        if (!(!ServerHandler.SleepHunger || event.updateWorld() || event.getEntityPlayer().field_71075_bZ.field_75098_d || event.getEntityPlayer().field_70128_L || event.getEntityPlayer().field_70170_p.field_72995_K)) {
            World world = event.getEntityPlayer().field_70170_p;
            long sleepTime = 24000L - world.func_82737_E();
            int hungerInterval = 300;
            float hungerLoss = Math.round(sleepTime / (long)hungerInterval);
            event.getEntityPlayer().func_71024_bL().func_75113_a(hungerLoss);
        }
    }

    @SubscribeEvent
    public void PlayerHurt(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getEntityLiving() instanceof EntityPlayer && ServerHandler.ReducePoison && (player = (EntityPlayer)event.getEntityLiving()).func_70644_a(Potion.func_188412_a((int)19)) && event.getSource().field_76373_n == DamageSource.field_76376_m.func_76355_l()) {
            event.setAmount(ServerHandler.DmgDecrease);
        }
    }

    @SubscribeEvent
    public void hungerLoss(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && ServerHandler.hungerLoss) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (!player.field_70170_p.field_72995_K && !player.func_184812_l_()) {
                player.func_71024_bL().func_75113_a(ServerHandler.exhaustion);
            }
        }
    }

    @SubscribeEvent
    public void entityUpdate(LivingEvent.LivingUpdateEvent event) {
        ItemStack itemstack;
        boolean flag;
        BlockPos blockpos;
        float f;
        if (event.getEntity() instanceof EntityZombie && ServerHandler.BurnBaby) {
            EntityZombie zombie = (EntityZombie)event.getEntity();
            if (zombie.field_70170_p.func_72935_r() && !zombie.field_70170_p.field_72995_K && zombie.func_70631_g_()) {
                f = zombie.func_70013_c(1.0f);
                BlockPos blockPos = blockpos = zombie.func_184187_bx() instanceof EntityBoat ? new BlockPos(zombie.field_70165_t, (double)Math.round(zombie.field_70163_u), zombie.field_70161_v).func_177984_a() : new BlockPos(zombie.field_70165_t, (double)Math.round(zombie.field_70163_u), zombie.field_70161_v);
                if (f > 0.5f && zombie.field_70170_p.field_73012_v.nextFloat() * 20.0f < (f - 0.4f) * 2.0f && zombie.field_70170_p.func_175678_i(blockpos)) {
                    flag = true;
                    itemstack = zombie.func_184582_a(EntityEquipmentSlot.HEAD);
                    if (itemstack != null) {
                        if (itemstack.func_77984_f()) {
                            itemstack.func_77964_b(itemstack.func_77952_i() + zombie.field_70170_p.field_73012_v.nextInt(2));
                            if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                                zombie.func_70669_a(itemstack);
                                zombie.func_184201_a(EntityEquipmentSlot.HEAD, (ItemStack)null);
                            }
                        }
                        flag = false;
                    }
                    if (flag) {
                        zombie.func_70015_d(100);
                    }
                }
            }
        }
        if (event.getEntity() instanceof EntityBat && ServerHandler.BurnBat) {
            EntityBat bat = (EntityBat)event.getEntity();
            if (bat.field_70170_p.func_72935_r() && !bat.field_70170_p.field_72995_K) {
                f = bat.func_70013_c(1.0f);
                blockpos = new BlockPos(bat.field_70165_t, (double)Math.round(bat.field_70163_u), bat.field_70161_v);
                if (f > 0.5f && bat.field_70170_p.field_73012_v.nextFloat() * 20.0f < (f - 0.4f) * 2.0f && bat.field_70170_p.func_175678_i(blockpos)) {
                    flag = true;
                    itemstack = bat.func_184582_a(EntityEquipmentSlot.HEAD);
                    if (itemstack != null) {
                        if (itemstack.func_77984_f()) {
                            itemstack.func_77964_b(itemstack.func_77952_i() + bat.field_70170_p.field_73012_v.nextInt(2));
                            if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                                bat.func_70669_a(itemstack);
                                bat.func_184201_a(EntityEquipmentSlot.HEAD, (ItemStack)null);
                            }
                        }
                        flag = false;
                    }
                    if (flag) {
                        bat.func_70015_d(100);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (ServerHandler.NoMoreRain && event.world.func_72912_H().func_76059_o()) {
            event.world.func_72912_H().func_76084_b(false);
        }
        if (ServerHandler.NoMoreThunder && event.world.func_72912_H().func_76061_m()) {
            event.world.func_72912_H().func_76069_a(false);
        }
    }

    @SubscribeEvent
    public void playerUpdate(LivingEvent.LivingUpdateEvent updateEvent) {
        EntityLivingBase entity = updateEvent.getEntityLiving();
        if (ModularsHandler.hardcore && ServerHandler.netherrackBurn) {
            this.burnPlayer(entity);
        }
    }

    private void burnPlayer(EntityLivingBase entity) {
        if (ServerHandler.netherrackBurn && entity.field_71093_bK == -1 && entity.field_70173_aa % 50 == 0 && !entity.field_70160_al) {
            World world = entity.field_70170_p;
            BlockPos entityPos = entity.func_180425_c();
            BlockPos ground = new BlockPos(entityPos.func_177958_n(), entityPos.func_177956_o() - 1, entityPos.func_177952_p());
            Block block = world.func_180495_p(ground).func_177230_c();
            if (!((!(entity instanceof EntityPlayer) || ((EntityPlayer)entity).field_71075_bZ.field_75098_d) && entity instanceof EntityPlayer || entity.func_70660_b(MobEffects.field_76426_n) != null && entity.func_70045_F() || block != Blocks.field_150424_aL)) {
                entity.func_70015_d(ServerHandler.burnTime);
            }
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (ServerHandler.pigmanAngry) {
            EntityPlayer player = event.getPlayer();
            int chance = event.getWorld().field_73012_v.nextInt(ServerHandler.pigmanAngryChance);
            List list = player.func_130014_f_().func_72872_a(EntityPigZombie.class, player.func_174813_aQ().func_72314_b(20.0, 20.0, 20.0));
            if (!player.field_71075_bZ.field_75098_d && chance == 0 && !list.isEmpty()) {
                for (EntityPigZombie entity : list) {
                    entity.func_70604_c((EntityLivingBase)player);
                    entity.func_70624_b((EntityLivingBase)player);
                }
            }
        }
    }
}

