/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.knobcontrol.modulars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MobDrops {
    public static final HashMap<String, ArrayList<ItemDrop>> MOB_DROP_LIST = new HashMap();
    public static final HashMap<String, ArrayList<ItemDrop>> MOB_DROP_LIST_PLAYER_KILL = new HashMap();

    public static void generateConfigFile(Configuration config) {
        MOB_DROP_LIST.clear();
        MOB_DROP_LIST_PLAYER_KILL.clear();
        for (Map.Entry entity : EntityList.field_75625_b.entrySet()) {
            Class clazz = (Class)entity.getValue();
            if (!EntityLivingBase.class.isAssignableFrom(clazz)) continue;
            config.addCustomCategoryComment((String)entity.getKey(), "Adding Drops Example: \nModID:Item:Meta:Qty(Random 1 - number set):Chance(0.01 - 1) \nminecraft:glass:0:15:1 ");
            MOB_DROP_LIST.put((String)entity.getKey(), ItemDrop.getArrayItemDrops(config.get((String)entity.getKey(), "drops", new String[0]).getStringList()));
            MOB_DROP_LIST_PLAYER_KILL.put((String)entity.getKey(), ItemDrop.getArrayItemDrops(config.get((String)entity.getKey(), "player kill drops", new String[0]).getStringList()));
        }
        config.save();
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entityliving = event.getEntityLiving();
        if (MOB_DROP_LIST.containsKey(EntityList.func_75621_b((Entity)entityliving))) {
            for (ItemDrop drop : MOB_DROP_LIST.get(EntityList.func_75621_b((Entity)entityliving))) {
                if (!drop.shouldDrop(entityliving.func_70681_au())) continue;
                entityliving.func_70099_a(drop.getStack(entityliving.func_70681_au()), 0.0f);
            }
        }
        if (this.isPlayerKill(event.getSource()) && MOB_DROP_LIST_PLAYER_KILL.containsKey(EntityList.func_75621_b((Entity)entityliving))) {
            for (ItemDrop drop : MOB_DROP_LIST_PLAYER_KILL.get(EntityList.func_75621_b((Entity)entityliving))) {
                if (!drop.shouldDrop(entityliving.func_70681_au())) continue;
                entityliving.func_70099_a(drop.getStack(entityliving.func_70681_au()), 0.0f);
            }
        }
    }

    private boolean isPlayerKill(DamageSource source) {
        if (source.func_76364_f() instanceof EntityArrow) {
            return ((EntityArrow)source.func_76364_f()).field_70250_c instanceof EntityPlayer;
        }
        return source.func_76346_g() instanceof EntityPlayer;
    }

    public static class ItemDrop {
        String itemID;
        int metaID;
        double chance;
        int qty;

        public ItemDrop(String itemID, int metaID, double chance, int qty) {
            this.itemID = itemID;
            this.metaID = metaID;
            this.chance = chance;
            this.qty = qty;
        }

        public static ArrayList<ItemDrop> getArrayItemDrops(String[] itemList) {
            ArrayList<ItemDrop> drops = new ArrayList<ItemDrop>();
            for (String item : itemList) {
                try {
                    drops.add(ItemDrop.getItemDrop(item));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            return drops;
        }

        public Item getItem() {
            return Item.func_111206_d((String)this.itemID);
        }

        public int getMeta() {
            return this.metaID;
        }

        public static ItemDrop getItemDrop(String data) throws NumberFormatException {
            String[] split = data.split(":");
            String itemID = split[0] + ":" + split[1];
            int metaID = Integer.parseInt(split[2]);
            double chance = Double.parseDouble(split[4]);
            int qty = Integer.parseInt(split[3]);
            return new ItemDrop(itemID, metaID, chance, qty);
        }

        public boolean shouldDrop(Random rand) {
            return rand.nextDouble() <= this.chance;
        }

        public ItemStack getStack(Random rand) {
            return new ItemStack(Item.func_111206_d((String)this.itemID), this.qty > 1 ? rand.nextInt(this.qty - 1) + 1 : this.qty, this.metaID);
        }
    }
}

