/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.knobcontrol.main;

import com.kashdeya.knobcontrol.config.Config;
import com.kashdeya.knobcontrol.handlers.BedrockHandler;
import com.kashdeya.knobcontrol.handlers.ClientHandler;
import com.kashdeya.knobcontrol.handlers.ModularsHandler;
import com.kashdeya.knobcontrol.handlers.ServerHandler;
import com.kashdeya.knobcontrol.modulars.Crafting;
import com.kashdeya.knobcontrol.modulars.Events;
import com.kashdeya.knobcontrol.modulars.Furnace;
import com.kashdeya.knobcontrol.modulars.ItemStacks;
import com.kashdeya.knobcontrol.modulars.LightLevels;
import com.kashdeya.knobcontrol.modulars.MobDrops;
import com.kashdeya.knobcontrol.modulars.MobSpawns;
import com.kashdeya.knobcontrol.modulars.OreControl;
import com.kashdeya.knobcontrol.modulars.RandomBones;
import com.kashdeya.knobcontrol.modulars.Remove;
import com.kashdeya.knobcontrol.modulars.RemoveDrops;
import com.kashdeya.knobcontrol.modulars.RemoveMobs;
import com.kashdeya.knobcontrol.modulars.TerrainControl;
import com.kashdeya.knobcontrol.modulars.Uncrafting;
import com.kashdeya.knobcontrol.proxy.CommonProxy;
import com.kashdeya.knobcontrol.util.Client;
import com.kashdeya.knobcontrol.util.PotionShift;
import com.kashdeya.knobcontrol.util.Server;
import java.io.File;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="kc", name="Knob Control", version="2.0.12", acceptedMinecraftVersions="[1.10.2]")
public class KnobControl {
    @Mod.Instance(value="kc")
    public static KnobControl instance;
    @SidedProxy(clientSide="com.kashdeya.knobcontrol.proxy.ClientProxy", serverSide="com.kashdeya.knobcontrol.proxy.CommonProxy")
    public static CommonProxy PROXY;
    public static final File configDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        Config.initCrafting();
        Config.initEvents();
        Config.initFurnace();
        Config.initHardcore();
        Config.initMain();
        Config.initMobSpawns();
        Config.initOreControl();
        Config.initRandomBones();
        Config.initRemove();
        Config.initRemoveMobs();
        Config.initStacks();
        Config.initTerrainControl();
        Config.initUncrafting();
        Config.initRemoveDrops();
        Config.initLightLevels();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        if (ModularsHandler.events) {
            MinecraftForge.EVENT_BUS.register((Object)new Events());
        }
        if (ModularsHandler.oreControl) {
            MinecraftForge.ORE_GEN_BUS.register((Object)new OreControl());
        }
        if (ModularsHandler.randomBones) {
            MinecraftForge.EVENT_BUS.register((Object)new RandomBones());
        }
        if (ModularsHandler.removeDrops) {
            MinecraftForge.EVENT_BUS.register((Object)new RemoveDrops());
        }
        if (ModularsHandler.removeMobs) {
            MinecraftForge.EVENT_BUS.register((Object)new RemoveMobs());
        }
        if (ModularsHandler.lightLevels) {
            MinecraftForge.EVENT_BUS.register((Object)new LightLevels());
        }
        if (ModularsHandler.terrainControl) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new TerrainControl());
        }
        if (ModularsHandler.mobDrops) {
            MinecraftForge.EVENT_BUS.register((Object)new MobDrops());
        }
        if (ModularsHandler.mobSpawns) {
            MobSpawns.spawn();
        }
        if (ModularsHandler.itemStacks) {
            ItemStacks.registerTweaks();
        }
        MinecraftForge.EVENT_BUS.register((Object)new Server());
        if (e.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new Client());
            if (ClientHandler.potionShift) {
                MinecraftForge.EVENT_BUS.register((Object)new PotionShift());
            }
        }
        if (ModularsHandler.crafting) {
            Crafting.registerRecipes();
        }
        if (ModularsHandler.remove) {
            Remove.registerRecipes();
        }
        if (ModularsHandler.uncrafting) {
            Uncrafting.registerRecipes();
        }
        if (ModularsHandler.furnace) {
            GameRegistry.registerFuelHandler((IFuelHandler)new Furnace());
        }
        if (BedrockHandler.flatBedrock) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new BedrockHandler(), (int)0);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        PROXY.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        MobDrops.generateConfigFile(new Configuration(new File(configDir, "Mob Drops Modular.cfg")));
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent e) {
        GameRules game = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0].func_82736_K();
        if (ServerHandler.keepInvo) {
            game.func_82764_b("keepInventory", "true");
        }
        if (ServerHandler.regenOff) {
            game.func_82764_b("naturalRegeneration", "false");
        }
        if (ServerHandler.lightCycle) {
            game.func_82764_b("doDaylightCycle", "false");
        }
        if (ServerHandler.fireTick) {
            game.func_82764_b("doFireTick", "false");
        }
        if (ServerHandler.mobGriefing) {
            game.func_82764_b("mobGriefing", "false");
        }
        if (ServerHandler.pvp) {
            game.func_82764_b("pvp", "false");
        }
    }

    static {
        configDir = new File("config/Knob Control");
    }
}

