/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.logic;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.clientinfo.ConnectorInfo;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;

public class ChannelInfo {
    public static final int MAX_CHANNELS = 8;
    private final IChannelType type;
    private final IChannelSettings channelSettings;
    private String channelName;
    private boolean enabled = true;
    private final Map<SidedConsumer, ConnectorInfo> connectors = new HashMap<SidedConsumer, ConnectorInfo>();

    public ChannelInfo(IChannelType type) {
        this.type = type;
        this.channelSettings = type.createChannel();
    }

    @Nonnull
    public String getChannelName() {
        return this.channelName == null ? "" : this.channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public IChannelType getType() {
        return this.type;
    }

    public IChannelSettings getChannelSettings() {
        return this.channelSettings;
    }

    public Map<SidedConsumer, ConnectorInfo> getConnectors() {
        return this.connectors;
    }

    public ConnectorInfo createConnector(SidedConsumer id, boolean advanced) {
        ConnectorInfo info = new ConnectorInfo(this.type, id, advanced);
        this.connectors.put(id, info);
        return info;
    }

    public void writeToNBT(NBTTagCompound tag) {
        this.channelSettings.writeToNBT(tag);
        tag.func_74757_a("enabled", this.enabled);
        if (this.channelName != null && !this.channelName.isEmpty()) {
            tag.func_74778_a("name", this.channelName);
        }
        NBTTagList conlist = new NBTTagList();
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.connectors.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            ConnectorInfo connectorInfo = entry.getValue();
            connectorInfo.writeToNBT(tc);
            tc.func_74768_a("consumerId", entry.getKey().getConsumerId().getId());
            tc.func_74768_a("side", entry.getKey().getSide().ordinal());
            tc.func_74778_a("type", connectorInfo.getType().getID());
            tc.func_74757_a("advanced", connectorInfo.isAdvanced());
            conlist.func_74742_a((NBTBase)tc);
        }
        tag.func_74782_a("connectors", (NBTBase)conlist);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.channelSettings.readFromNBT(tag);
        this.enabled = tag.func_74767_n("enabled");
        this.channelName = tag.func_74764_b("name") ? tag.func_74779_i("name") : null;
        NBTTagList conlist = tag.func_150295_c("connectors", 10);
        for (int i = 0; i < conlist.func_74745_c(); ++i) {
            NBTTagCompound tc = conlist.func_150305_b(i);
            String id = tc.func_74779_i("type");
            IChannelType type = XNet.xNetApi.findType(id);
            if (type == null) {
                XNet.logger.warn("Unsupported type " + id + "!");
                continue;
            }
            if (!this.getType().equals(type)) {
                XNet.logger.warn("Trying to load a connector with non-matching type " + type + "!");
                continue;
            }
            ConsumerId consumerId = new ConsumerId(tc.func_74762_e("consumerId"));
            EnumFacing side = EnumFacing.field_82609_l[tc.func_74762_e("side")];
            SidedConsumer key = new SidedConsumer(consumerId, side);
            boolean advanced = tc.func_74767_n("advanced");
            ConnectorInfo connectorInfo = new ConnectorInfo(type, key, advanced);
            connectorInfo.readFromNBT(tc);
            this.connectors.put(key, connectorInfo);
        }
    }
}

