/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.items;

import java.util.List;
import mcjty.lib.compat.CompatItem;
import mcjty.lib.tools.ChatTools;
import mcjty.xnet.XNet;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.blocks.cables.ConnectorBlock;
import mcjty.xnet.blocks.cables.ConnectorTileEntity;
import mcjty.xnet.blocks.cables.NetCableSetup;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.blocks.generic.GenericCableBlock;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConnectorUpgradeItem
extends CompatItem {
    public ConnectorUpgradeItem() {
        this.func_77655_b("xnet.connector_upgrade");
        this.setRegistryName("connector_upgrade");
        this.func_77637_a(XNet.tabXNet);
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void clAddInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.clAddInformation(stack, playerIn, tooltip, advanced);
        tooltip.add(TextFormatting.BLUE + "Sneak right click this on a");
        tooltip.add(TextFormatting.BLUE + "normal connector to upgrade it");
        tooltip.add(TextFormatting.BLUE + "to an advanced connector");
    }

    protected EnumActionResult clOnItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == NetCableSetup.connectorBlock) {
            TileEntity te;
            if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof ConnectorTileEntity) {
                NBTTagCompound tag = new NBTTagCompound();
                te.func_189515_b(tag);
                CableColor color = (CableColor)((Object)world.func_180495_p(pos).func_177229_b(GenericCableBlock.COLOR));
                XNetBlobData blobData = XNetBlobData.getBlobData(world);
                WorldBlob worldBlob = blobData.getWorldBlob(world);
                ConsumerId consumer = worldBlob.getConsumerAt(pos);
                ((ConnectorBlock)block).unlinkBlock(world, pos);
                world.func_175656_a(pos, NetCableSetup.advancedConnectorBlock.func_176223_P().func_177226_a(GenericCableBlock.COLOR, (Comparable)((Object)color)));
                IBlockState blockState = world.func_180495_p(pos);
                ((ConnectorBlock)blockState.func_177230_c()).createCableSegment(world, pos, consumer);
                te = TileEntity.func_190200_a((World)world, (NBTTagCompound)tag);
                if (te != null) {
                    world.func_175726_f(pos).func_150813_a(te);
                    te.func_70296_d();
                    world.func_184138_a(pos, blockState, blockState, 3);
                    player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                    player.field_71070_bA.func_75142_b();
                    ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.GREEN + "Connector was upgraded"));
                } else {
                    ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "Something went wrong during upgrade!"));
                    return EnumActionResult.FAIL;
                }
            }
            return EnumActionResult.SUCCESS;
        }
        if (block == NetCableSetup.advancedConnectorBlock) {
            if (!world.field_72995_K) {
                ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.YELLOW + "This connector is already advanced!"));
            }
            return EnumActionResult.SUCCESS;
        }
        if (!world.field_72995_K) {
            ChatTools.addChatMessage((ICommandSender)player, (ITextComponent)new TextComponentString(TextFormatting.RED + "Use this item on a connector to upgrade it!"));
        }
        return EnumActionResult.SUCCESS;
    }
}

