/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.facade;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.xnet.blocks.cables.NetCableBlock;
import mcjty.xnet.blocks.cables.NetCableSetup;
import mcjty.xnet.blocks.facade.FacadeBakedModel;
import mcjty.xnet.blocks.facade.FacadeBlockId;
import mcjty.xnet.blocks.facade.FacadeItemBlock;
import mcjty.xnet.blocks.facade.FacadeTileEntity;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FacadeBlock
extends NetCableBlock
implements ITileEntityProvider {
    public static final String FACADE = "facade";

    public FacadeBlock() {
        super(Material.field_151573_f, FACADE);
        this.initTileEntity();
        this.func_149711_c(0.8f);
    }

    @Override
    protected ItemBlock createItemBlock() {
        return new FacadeItemBlock(this);
    }

    @Override
    protected void clGetSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(new ItemStack(itemIn));
    }

    protected void initTileEntity() {
        GameRegistry.registerTileEntity(FacadeTileEntity.class, (String)"xnet_facade");
    }

    @Override
    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        return super.originalCollisionRayTrace(blockState, world, pos, start, end);
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public TileEntity createTileEntity(World world, IBlockState metadata) {
        return new FacadeTileEntity();
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        ItemStack item = new ItemStack((Block)ModBlocks.facadeBlock);
        IBlockState mimicBlock = te instanceof FacadeTileEntity ? ((FacadeTileEntity)te).getMimicBlock() : Blocks.field_150347_e.func_176223_P();
        FacadeItemBlock.setMimicBlock(item, mimicBlock);
        FacadeBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        CableColor color = (CableColor)((Object)state.func_177229_b((IProperty)COLOR));
        this.func_176208_a(world, pos, state, player);
        return world.func_180501_a(pos, NetCableSetup.netCableBlock.func_176223_P().func_177226_a((IProperty)COLOR, (Comparable)((Object)color)), world.field_72995_K ? 11 : 3);
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        IBlockState mimicBlock = this.getMimicBlock(world, pos);
        if (mimicBlock != null) {
            return extendedBlockState.withProperty((IUnlistedProperty)FACADEID, (Object)new FacadeBlockId(mimicBlock.func_177230_c().getRegistryName().toString(), mimicBlock.func_177230_c().func_176201_c(mimicBlock)));
        }
        return extendedBlockState;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.originalBreakBlock(world, pos, state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMapperBase ignoreState = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return FacadeBakedModel.modelFacade;
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)ignoreState);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initItemModel() {
        Item itemBlock = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("xnet", FACADE));
        ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation(this.getRegistryName(), "inventory");
        boolean DEFAULT_ITEM_SUBTYPE = false;
        Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(itemBlock, 0, itemModelResourceLocation);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.getMimicBlock(blockAccess, pos).func_185894_c(blockAccess, pos, side);
    }

    @Override
    public boolean func_149637_q(IBlockState blockState) {
        return true;
    }

    @Override
    public boolean func_149662_c(IBlockState blockState) {
        return true;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return true;
    }
}

