/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.controller.gui;

import java.awt.Rectangle;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericEnergyStorageTileEntity;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.network.Argument;
import mcjty.lib.tools.MinecraftTools;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.api.keys.SidedPos;
import mcjty.xnet.blocks.controller.ControllerContainer;
import mcjty.xnet.blocks.controller.TileEntityController;
import mcjty.xnet.blocks.controller.gui.ChannelEditorPanel;
import mcjty.xnet.blocks.controller.gui.ControllerEditorPanel;
import mcjty.xnet.clientinfo.ChannelClientInfo;
import mcjty.xnet.clientinfo.ConnectedBlockClientInfo;
import mcjty.xnet.clientinfo.ConnectorClientInfo;
import mcjty.xnet.network.PacketGetChannels;
import mcjty.xnet.network.PacketGetConnectedBlocks;
import mcjty.xnet.network.XNetMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiController
extends GenericGuiContainer<TileEntityController> {
    public static final int SIDEWIDTH = 80;
    public static final int WIDTH = 256;
    public static final int HEIGHT = 236;
    public static final String TAG_ENABLED = "enabled";
    public static final String TAG_NAME = "name";
    private WidgetList connectorList;
    private int listDirty;
    private Panel channelEditPanel;
    private Panel connectorEditPanel;
    private ToggleButton[] channelButtons = new ToggleButton[8];
    private SidedPos editingConnector = null;
    private int editingChannel = -1;
    private int showingChannel = -1;
    private SidedPos showingConnector = null;
    private EnergyBar energyBar;
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    private static final ResourceLocation mainBackground = new ResourceLocation("xnet", "textures/gui/controller.png");
    private static final ResourceLocation sideBackground = new ResourceLocation("xnet", "textures/gui/sidegui.png");
    public static List<ChannelClientInfo> fromServer_channels = null;
    public static List<ConnectedBlockClientInfo> fromServer_connectedBlocks = null;
    private boolean needsRefresh = true;

    public GuiController(TileEntityController controller, ControllerContainer container) {
        super((ModBase)XNet.instance, XNetMessages.INSTANCE, (GenericTileEntity)controller, (Container)container, 0, "controller");
        this.field_146999_f = 256;
        this.field_147000_g = 236;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackgrounds(sideBackground, mainBackground)).setBackgroundLayout(true, 80);
        toplevel.setBounds(new Rectangle(this.field_147003_i - 80, this.field_147009_r, this.field_146999_f + 80, this.field_147000_g));
        this.initEnergyBar();
        Panel listPanel = this.initConnectorListPanel();
        Panel channelSelectionPanel = this.initChannelSelectionPanel();
        this.initEditPanels();
        ((Panel)((Panel)((Panel)((Panel)toplevel.addChild((Widget)channelSelectionPanel)).addChild((Widget)listPanel)).addChild((Widget)this.channelEditPanel)).addChild((Widget)this.connectorEditPanel)).addChild((Widget)this.energyBar);
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        this.editingConnector = null;
        this.editingChannel = -1;
        this.refresh();
        this.listDirty = 0;
        int currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((TileEntityController)this.tileEntity).requestRfFromServer("xnet");
    }

    private void initEnergyBar() {
        int maxEnergyStored = ((TileEntityController)this.tileEntity).getMaxEnergyStored(EnumFacing.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setHorizontal().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 7, 35, 11))).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
    }

    private void initEditPanels() {
        this.channelEditPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setFilledRectThickness(-1)).setFilledBackground(StyleConfig.colorListBackground)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(171, 5, 161, 37));
        this.connectorEditPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setFilledRectThickness(-1)).setFilledBackground(StyleConfig.colorListBackground)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(171, 45, 161, 108));
    }

    private Panel initConnectorListPanel() {
        this.connectorList = new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget parent, int index) {
            }

            public void doubleClick(Widget parent, int index) {
                GuiController.this.hilightSelectedContainer(index);
            }
        });
        this.connectorList.setPropagateEventsToChildren(true);
        Slider listSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(10)).setVertical().setScrollable((Scrollable)this.connectorList);
        return (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(3)).setSpacing(1)).addChild((Widget)this.connectorList)).addChild((Widget)listSlider)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(2, 20, 169, 214));
    }

    private void hilightSelectedContainer(int index) {
        if (index < 0) {
            return;
        }
        ConnectedBlockClientInfo c = fromServer_connectedBlocks.get(index);
        if (c != null) {
            XNet.instance.clientInfo.hilightBlock(c.getPos().getPos(), System.currentTimeMillis() + 5000L);
            Logging.message((EntityPlayer)MinecraftTools.getPlayer((Minecraft)this.field_146297_k), (String)"The block is now highlighted");
            MinecraftTools.getPlayer((Minecraft)this.field_146297_k).func_71053_j();
        }
    }

    private Panel initChannelSelectionPanel() {
        Panel channelSelectionPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(0)).setSpacing(0)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(41, 1, 124, 24));
        for (int i = 0; i < 8; ++i) {
            String channel = String.valueOf(i + 1);
            this.channelButtons[i] = (ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.field_146297_k, (Gui)this).setDesiredWidth(14)).setText(channel)).setTooltips(new String[]{"Edit channel " + channel});
            int finalI = i;
            this.channelButtons[i].addButtonEvent(parent -> this.selectChannelEditor(finalI));
            channelSelectionPanel.addChild((Widget)this.channelButtons[i]);
        }
        return channelSelectionPanel;
    }

    private void selectChannelEditor(int finalI) {
        this.editingChannel = -1;
        this.showingConnector = null;
        for (int j = 0; j < 8; ++j) {
            if (j == finalI) continue;
            this.channelButtons[j].setPressed(false);
            this.editingChannel = finalI;
        }
    }

    private void removeConnector(SidedPos sidedPos) {
        this.sendServerCommand(XNetMessages.INSTANCE, "removeConnector", new Argument[]{new Argument("channel", this.getSelectedChannel()), new Argument("pos", sidedPos.getPos()), new Argument("side", sidedPos.getSide().ordinal())});
        this.refresh();
    }

    private void createConnector(SidedPos sidedPos) {
        this.sendServerCommand(XNetMessages.INSTANCE, "createConnector", new Argument[]{new Argument("channel", this.getSelectedChannel()), new Argument("pos", sidedPos.getPos()), new Argument("side", sidedPos.getSide().ordinal())});
        this.refresh();
    }

    private void removeChannel() {
        this.sendServerCommand(XNetMessages.INSTANCE, "removeChannel", new Argument[]{new Argument("index", this.getSelectedChannel())});
        this.refresh();
    }

    private void createChannel(String typeId) {
        this.sendServerCommand(XNetMessages.INSTANCE, "createChannel", new Argument[]{new Argument("index", this.getSelectedChannel()), new Argument("type", typeId)});
        this.refresh();
    }

    public void refresh() {
        fromServer_channels = null;
        fromServer_connectedBlocks = null;
        this.showingChannel = -1;
        this.showingConnector = null;
        this.needsRefresh = true;
        this.listDirty = 3;
        this.requestListsIfNeeded();
    }

    private void selectConnectorEditor(SidedPos sidedPos, int finalI) {
        this.editingConnector = sidedPos;
        this.selectChannelEditor(finalI);
    }

    private void refreshChannelEditor() {
        if (!this.listsReady()) {
            return;
        }
        if (this.editingChannel != -1 && this.showingChannel != this.editingChannel) {
            this.showingChannel = this.editingChannel;
            this.channelButtons[this.editingChannel].setPressed(true);
            this.channelEditPanel.removeChildren();
            if (this.channelButtons[this.editingChannel].isPressed()) {
                ChannelClientInfo info = fromServer_channels.get(this.editingChannel);
                if (info != null) {
                    ChannelEditorPanel editor = new ChannelEditorPanel(this.channelEditPanel, this.field_146297_k, this, this.editingChannel);
                    editor.label("Channel " + (this.editingChannel + 1)).shift(5).toggle(TAG_ENABLED, "Enable processing on this channel", info.isEnabled()).shift(5).text(TAG_NAME, "Channel name", info.getChannelName(), 65);
                    info.getChannelSettings().createGui(editor);
                    Button remove = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("x")).setTextOffset(0, -1)).setTooltips(new String[]{"Remove this channel"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(151, 1, 9, 10))).addButtonEvent(parent -> this.removeChannel());
                    this.channelEditPanel.addChild((Widget)remove);
                    editor.setState(info.getChannelSettings());
                } else {
                    ChoiceLabel type = (ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 12, 95, 14));
                    for (IChannelType channelType : XNet.xNetApi.getChannels().values()) {
                        type.addChoices(new String[]{channelType.getID()});
                    }
                    Button create = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Create")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(100, 12, 53, 14))).addButtonEvent(parent -> this.createChannel(type.getCurrentChoice()));
                    ((Panel)this.channelEditPanel.addChild((Widget)type)).addChild((Widget)create);
                }
            }
        } else if (this.showingChannel != -1 && this.editingChannel == -1) {
            this.showingChannel = -1;
            this.channelEditPanel.removeChildren();
        }
    }

    private ConnectorClientInfo findClientInfo(ChannelClientInfo info, SidedPos p) {
        for (ConnectorClientInfo connector : info.getConnectors().values()) {
            if (!connector.getPos().equals(p)) continue;
            return connector;
        }
        return null;
    }

    private void refreshConnectorEditor() {
        if (!this.listsReady()) {
            return;
        }
        if (this.editingConnector != null && !this.editingConnector.equals(this.showingConnector)) {
            this.showingConnector = this.editingConnector;
            this.connectorEditPanel.removeChildren();
            ChannelClientInfo info = fromServer_channels.get(this.editingChannel);
            if (info != null) {
                ConnectorClientInfo clientInfo = this.findClientInfo(info, this.editingConnector);
                if (clientInfo != null) {
                    EnumFacing side = clientInfo.getPos().getSide();
                    SidedConsumer sidedConsumer = new SidedConsumer(clientInfo.getConsumerId(), side.func_176734_d());
                    ConnectorClientInfo connectorInfo = info.getConnectors().get(sidedConsumer);
                    Button remove = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("x")).setTextOffset(0, -1)).setTooltips(new String[]{"Remove this connector"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(151, 1, 9, 10))).addButtonEvent(parent -> this.removeConnector(this.editingConnector));
                    ControllerEditorPanel editor = new ControllerEditorPanel(this.connectorEditPanel, this.field_146297_k, this, this.editingChannel, this.editingConnector);
                    connectorInfo.getConnectorSettings().createGui(editor);
                    this.connectorEditPanel.addChild((Widget)remove);
                    editor.setState(connectorInfo.getConnectorSettings());
                } else {
                    Button create = ((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Create")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(85, 20, 60, 14))).addButtonEvent(parent -> this.createConnector(this.editingConnector));
                    this.connectorEditPanel.addChild((Widget)create);
                }
            }
        } else if (this.showingConnector != null && this.editingConnector == null) {
            this.showingConnector = null;
            this.connectorEditPanel.removeChildren();
        }
    }

    private void requestListsIfNeeded() {
        if (fromServer_channels != null && fromServer_connectedBlocks != null) {
            return;
        }
        --this.listDirty;
        if (this.listDirty <= 0) {
            XNetMessages.INSTANCE.sendToServer((IMessage)new PacketGetChannels(((TileEntityController)this.tileEntity).func_174877_v()));
            XNetMessages.INSTANCE.sendToServer((IMessage)new PacketGetConnectedBlocks(((TileEntityController)this.tileEntity).func_174877_v()));
            this.listDirty = 10;
            this.showingChannel = -1;
            this.showingConnector = null;
        }
    }

    private int getSelectedChannel() {
        for (int i = 0; i < 8; ++i) {
            if (!this.channelButtons[i].isPressed()) continue;
            return i;
        }
        return -1;
    }

    private void populateList() {
        if (!this.listsReady()) {
            return;
        }
        if (!this.needsRefresh) {
            return;
        }
        this.needsRefresh = false;
        this.connectorList.removeChildren();
        int sel = this.connectorList.getSelected();
        BlockPos prevPos = null;
        for (ConnectedBlockClientInfo connectedBlock : fromServer_connectedBlocks) {
            BlockRender br;
            SidedPos sidedPos = connectedBlock.getPos();
            BlockPos coordinate = sidedPos.getPos();
            String name = connectedBlock.getName();
            String blockUnlocName = connectedBlock.getBlockUnlocName();
            String blockName = I18n.func_135052_a((String)blockUnlocName, (Object[])new Object[0]).trim();
            int color = StyleConfig.colorTextInListNormal;
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(0)).setSpacing(0));
            if (coordinate.equals(prevPos)) {
                br = new BlockRender(this.field_146297_k, (Gui)this);
            } else {
                br = new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)connectedBlock.getConnectedBlock());
                prevPos = coordinate;
            }
            panel.addChild((Widget)br);
            if (!name.isEmpty()) {
                br.setTooltips(new String[]{TextFormatting.GREEN + "Connector: " + TextFormatting.WHITE + name, TextFormatting.GREEN + "Block: " + TextFormatting.WHITE + blockName, TextFormatting.GREEN + "Position: " + TextFormatting.WHITE + BlockPosTools.toString((BlockPos)coordinate), TextFormatting.WHITE + "(doubleclick to highlight)"});
            } else {
                br.setTooltips(new String[]{TextFormatting.GREEN + "Block: " + TextFormatting.WHITE + blockName, TextFormatting.GREEN + "Position: " + TextFormatting.WHITE + BlockPosTools.toString((BlockPos)coordinate), TextFormatting.WHITE + "(doubleclick to highlight)"});
            }
            panel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText(sidedPos.getSide().func_176610_l().substring(0, 1).toUpperCase()).setColor(color).setDesiredWidth(18));
            int i = 0;
            while (i < 8) {
                ConnectorClientInfo clientInfo;
                Button but = (Button)new Button(this.field_146297_k, (Gui)this).setDesiredWidth(14);
                ChannelClientInfo info = fromServer_channels.get(i);
                if (info != null && (clientInfo = this.findClientInfo(info, sidedPos)) != null) {
                    String indicator;
                    IndicatorIcon icon = clientInfo.getConnectorSettings().getIndicatorIcon();
                    if (icon != null) {
                        but.setImage(icon.getImage(), icon.getU(), icon.getV(), icon.getIw(), icon.getIh());
                    }
                    but.setText((indicator = clientInfo.getConnectorSettings().getIndicator()) != null ? indicator : "");
                }
                int finalI = i++;
                but.addButtonEvent(parent -> this.selectConnectorEditor(sidedPos, finalI));
                panel.addChild((Widget)but);
            }
            this.connectorList.addChild((Widget)panel);
        }
        this.connectorList.setSelected(sel);
    }

    private boolean listsReady() {
        return fromServer_channels != null && fromServer_connectedBlocks != null;
    }

    protected void func_146976_a(float v, int x1, int x2) {
        this.requestListsIfNeeded();
        this.populateList();
        this.refreshChannelEditor();
        this.refreshConnectorEditor();
        if (fromServer_channels != null) {
            for (int i = 0; i < 8; ++i) {
                String channel = String.valueOf(i + 1);
                ChannelClientInfo info = fromServer_channels.get(i);
                if (info != null) {
                    String indicator;
                    IndicatorIcon icon = info.getChannelSettings().getIndicatorIcon();
                    if (icon != null) {
                        this.channelButtons[i].setImage(icon.getImage(), icon.getU(), icon.getV(), icon.getIw(), icon.getIh());
                    }
                    if ((indicator = info.getChannelSettings().getIndicator()) != null) {
                        this.channelButtons[i].setText(indicator + channel);
                        continue;
                    }
                    this.channelButtons[i].setText(channel);
                    continue;
                }
                this.channelButtons[i].setImage(null, 0, 0, 0, 0);
                this.channelButtons[i].setText(channel);
            }
        }
        this.drawWindow();
        int channel = this.getSelectedChannel();
        if (channel != -1) {
            int x = (int)this.window.getToplevel().getBounds().getX();
            int y = (int)this.window.getToplevel().getBounds().getY();
            RenderHelper.drawVerticalGradientRect((int)(x + channel * 14 + 41), (int)(y + 22), (int)(x + channel * 14 + 41 + 12), (int)(y + 230), (int)0x33AAFFFF, (int)0x33AAFFFF);
        }
        int currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((TileEntityController)this.tileEntity).requestRfFromServer("xnet");
    }
}

