/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.blocks.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.typed.Type;
import mcjty.xnet.XNet;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.keys.ConsumerId;
import mcjty.xnet.api.keys.NetworkId;
import mcjty.xnet.api.keys.SidedConsumer;
import mcjty.xnet.api.keys.SidedPos;
import mcjty.xnet.blocks.cables.ConnectorBlock;
import mcjty.xnet.blocks.cables.ConnectorTileEntity;
import mcjty.xnet.blocks.cables.NetCableSetup;
import mcjty.xnet.blocks.controller.gui.GuiController;
import mcjty.xnet.clientinfo.ChannelClientInfo;
import mcjty.xnet.clientinfo.ConnectedBlockClientInfo;
import mcjty.xnet.clientinfo.ConnectorClientInfo;
import mcjty.xnet.clientinfo.ConnectorInfo;
import mcjty.xnet.config.GeneralConfiguration;
import mcjty.xnet.logic.ChannelInfo;
import mcjty.xnet.logic.LogicTools;
import mcjty.xnet.multiblock.NetworkChecker;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class TileEntityController
extends GenericEnergyReceiverTileEntity
implements ITickable,
IControllerContext {
    public static final String CMD_GETCHANNELS = "getChannelInfo";
    public static final String CLIENTCMD_CHANNELSREADY = "channelsReady";
    public static final String CMD_GETCONNECTEDBLOCKS = "getConnectedBlocks";
    public static final String CLIENTCMD_CONNECTEDBLOCKSREADY = "connectedBlocksReady";
    public static final String CMD_CREATECONNECTOR = "createConnector";
    public static final String CMD_REMOVECONNECTOR = "removeConnector";
    public static final String CMD_UPDATECONNECTOR = "updateConnector";
    public static final String CMD_CREATECHANNEL = "createChannel";
    public static final String CMD_REMOVECHANNEL = "removeChannel";
    public static final String CMD_UPDATECHANNEL = "updateChannel";
    private NetworkId networkId;
    private final ChannelInfo[] channels = new ChannelInfo[8];
    private int colors = 0;
    private boolean error = false;
    private Map<SidedConsumer, IConnectorSettings>[] cachedConnectors = new Map[8];
    private Map<SidedConsumer, IConnectorSettings>[] cachedRoutedConnectors = new Map[8];
    private NetworkChecker networkChecker = null;

    public TileEntityController() {
        super(100000, 1000);
        for (int i = 0; i < 8; ++i) {
            this.channels[i] = null;
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean oldError = this.error;
        super.onDataPacket(net, packet);
        if (this.func_145831_w().field_72995_K && oldError != this.error) {
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Nonnull
    public NetworkChecker getNetworkChecker() {
        if (this.networkChecker == null) {
            this.networkChecker = new NetworkChecker();
            this.networkChecker.add(this.networkId);
            WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
            LogicTools.routers(this.func_145831_w(), this.networkId).forEach(router -> {
                this.networkChecker.add(worldBlob.getNetworksAt(router.func_174877_v()));
                NetworkId routerNetwork = worldBlob.getNetworkAt(router.func_174877_v());
                if (routerNetwork != null) {
                    LogicTools.routers(this.func_145831_w(), routerNetwork).filter(r -> router != r).forEach(r -> LogicTools.connectors(this.func_145831_w(), r.func_174877_v()).forEach(connectorPos -> this.networkChecker.add(worldBlob.getNetworkAt((BlockPos)connectorPos))));
                }
            });
        }
        return this.networkChecker;
    }

    @Override
    public World getControllerWorld() {
        return this.func_145831_w();
    }

    @Override
    public NetworkId getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(NetworkId networkId) {
        this.networkId = networkId;
        this.markDirtyQuick();
    }

    public ChannelInfo[] getChannels() {
        return this.channels;
    }

    private void checkNetwork(WorldBlob worldBlob) {
        if (this.networkId != null && this.getNetworkChecker().isDirtyAndMarkClean(worldBlob)) {
            for (int i = 0; i < 8; ++i) {
                if (this.channels[i] == null) continue;
                this.cleanCache(i);
            }
        }
    }

    @Override
    public boolean matchColor(int colorMask) {
        return (this.colors & colorMask) == colorMask;
    }

    public boolean inError() {
        if (this.func_145831_w().field_72995_K) {
            return this.error;
        }
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        return worldBlob.getNetworksAt(this.func_174877_v()).size() > 1;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
            if (worldBlob.getNetworksAt(this.func_174877_v()).size() > 1) {
                this.markDirtyClient();
                return;
            }
            this.checkNetwork(worldBlob);
            if (!this.checkAndConsumeRF(GeneralConfiguration.controllerRFT)) {
                return;
            }
            boolean dirty = false;
            int newcolors = 0;
            for (int i = 0; i < 8; ++i) {
                if (this.channels[i] == null || !this.channels[i].isEnabled()) continue;
                if (this.checkAndConsumeRF(GeneralConfiguration.controllerChannelRFT)) {
                    this.channels[i].getChannelSettings().tick(i, this);
                }
                newcolors |= this.channels[i].getChannelSettings().getColors();
                dirty = true;
            }
            if (newcolors != this.colors) {
                dirty = true;
                this.colors = newcolors;
            }
            if (dirty) {
                this.markDirtyQuick();
            }
        }
    }

    @Override
    public boolean checkAndConsumeRF(int rft) {
        if (rft > 0) {
            if (this.getEnergyStored() < rft) {
                return false;
            }
            this.consumeEnergy(rft);
            this.markDirtyQuick();
        }
        return true;
    }

    private void networkDirty() {
        if (this.networkId != null) {
            XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w()).incNetworkVersion(this.networkId);
        }
    }

    private void cleanCache(int channel) {
        this.cachedConnectors[channel] = null;
        this.cachedRoutedConnectors[channel] = null;
        this.channels[channel].getChannelSettings().cleanCache();
    }

    @Override
    @Nonnull
    public Map<SidedConsumer, IConnectorSettings> getConnectors(int channel) {
        if (this.cachedConnectors[channel] == null) {
            WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
            this.cachedConnectors[channel] = new HashMap<SidedConsumer, IConnectorSettings>();
            for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
                SidedConsumer sidedConsumer = entry.getKey();
                BlockPos pos = this.findConsumerPosition(sidedConsumer.getConsumerId());
                if (pos == null || !worldBlob.getNetworksAt(pos).contains(this.getNetworkId())) continue;
                this.cachedConnectors[channel].put(sidedConsumer, entry.getValue().getConnectorSettings());
            }
        }
        return this.cachedConnectors[channel];
    }

    @Override
    @Nonnull
    public Map<SidedConsumer, IConnectorSettings> getRoutedConnectors(int channel) {
        if (this.cachedRoutedConnectors[channel] == null) {
            this.cachedRoutedConnectors[channel] = new HashMap<SidedConsumer, IConnectorSettings>();
            if (!this.channels[channel].getChannelName().isEmpty()) {
                LogicTools.routers(this.func_145831_w(), this.networkId).forEach(router -> router.addRoutedConnectors(this.cachedRoutedConnectors[channel], this.func_174877_v(), channel, this.channels[channel].getType()));
            }
        }
        return this.cachedRoutedConnectors[channel];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        if (this.networkId != null) {
            tagCompound.func_74768_a("networkId", this.networkId.getId());
        }
        return super.func_189515_b(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.networkId = tagCompound.func_74764_b("networkId") ? new NetworkId(tagCompound.func_74762_e("networkId")) : null;
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        super.writeClientDataToNBT(tagCompound);
        if (!this.func_145831_w().field_72995_K) {
            tagCompound.func_74757_a("error", this.inError());
        }
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        super.readClientDataFromNBT(tagCompound);
        this.error = tagCompound.func_74767_n("error");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("colors", this.colors);
        for (int i = 0; i < 8; ++i) {
            if (this.channels[i] == null) continue;
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74778_a("type", this.channels[i].getType().getID());
            this.channels[i].writeToNBT(tc);
            tagCompound.func_74782_a("channel" + i, (NBTBase)tc);
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.colors = tagCompound.func_74762_e("colors");
        for (int i = 0; i < 8; ++i) {
            if (tagCompound.func_74764_b("channel" + i)) {
                NBTTagCompound tc = (NBTTagCompound)tagCompound.func_74781_a("channel" + i);
                String id = tc.func_74779_i("type");
                IChannelType type = XNet.xNetApi.findType(id);
                if (type == null) {
                    XNet.logger.warn("Unsupported type " + id + "!");
                    continue;
                }
                this.channels[i] = new ChannelInfo(type);
                this.channels[i].readFromNBT(tc);
                continue;
            }
            this.channels[i] = null;
        }
    }

    @Override
    @Nullable
    public BlockPos findConsumerPosition(@Nonnull ConsumerId consumerId) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        return this.findConsumerPosition(worldBlob, consumerId);
    }

    @Nullable
    private BlockPos findConsumerPosition(@Nonnull WorldBlob worldBlob, @Nonnull ConsumerId consumerId) {
        return worldBlob.getConsumerPosition(consumerId);
    }

    @Nonnull
    private List<ConnectedBlockClientInfo> findConnectedBlocks() {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        HashSet<ConnectedBlockClientInfo> set = new HashSet<ConnectedBlockClientInfo>();
        for (BlockPos consumerPos : worldBlob.getConsumers(this.networkId)) {
            String name = "";
            TileEntity te = this.func_145831_w().func_175625_s(consumerPos);
            if (te instanceof ConnectorTileEntity) {
                name = ((ConnectorTileEntity)te).getConnectorName();
            } else {
                XNet.logger.warn("What? The connector at " + BlockPosTools.toString((BlockPos)consumerPos) + " is not a connector?");
            }
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos pos = consumerPos.func_177972_a(facing);
                if (!ConnectorBlock.isConnectable((IBlockAccess)this.func_145831_w(), pos)) continue;
                SidedPos sidedPos = new SidedPos(pos, facing.func_176734_d());
                IBlockState state = this.func_145831_w().func_180495_p(pos);
                ItemStack item = state.func_177230_c().func_185473_a(this.func_145831_w(), pos, state);
                ConnectedBlockClientInfo info = new ConnectedBlockClientInfo(sidedPos, item, name);
                set.add(info);
            }
        }
        ArrayList<ConnectedBlockClientInfo> list = new ArrayList<ConnectedBlockClientInfo>(set);
        list.sort((i1, i2) -> {
            if (i1.getPos().getPos().equals((Object)i2.getPos().getPos())) {
                return i1.getPos().getSide().compareTo((Enum)i2.getPos().getSide());
            }
            return i1.getPos().getPos().compareTo((Vec3i)i2.getPos().getPos());
        });
        return list;
    }

    @Nonnull
    private List<ChannelClientInfo> findChannelInfo() {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        ArrayList<ChannelClientInfo> chanList = new ArrayList<ChannelClientInfo>();
        for (ChannelInfo channel : this.channels) {
            if (channel != null) {
                ChannelClientInfo clientInfo = new ChannelClientInfo(channel.getChannelName(), channel.getType(), channel.getChannelSettings(), channel.isEnabled());
                for (Map.Entry<SidedConsumer, ConnectorInfo> entry : channel.getConnectors().entrySet()) {
                    BlockPos consumerPos;
                    SidedConsumer sidedConsumer = entry.getKey();
                    ConnectorInfo info = entry.getValue();
                    if (info.getConnectorSettings() == null || (consumerPos = this.findConsumerPosition(worldBlob, sidedConsumer.getConsumerId())) == null) continue;
                    SidedPos pos = new SidedPos(consumerPos.func_177972_a(sidedConsumer.getSide()), sidedConsumer.getSide().func_176734_d());
                    boolean advanced = this.func_145831_w().func_180495_p(consumerPos).func_177230_c() == NetCableSetup.advancedConnectorBlock;
                    ConnectorClientInfo ci = new ConnectorClientInfo(pos, sidedConsumer.getConsumerId(), channel.getType(), info.getConnectorSettings(), advanced);
                    clientInfo.getConnectors().put(sidedConsumer, ci);
                }
                chanList.add(clientInfo);
                continue;
            }
            chanList.add(null);
        }
        return chanList;
    }

    private void updateChannel(int channel, Map<String, Argument> args) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (Map.Entry<String, Argument> e : args.entrySet()) {
            data.put(e.getKey(), e.getValue().getValue());
        }
        this.channels[channel].getChannelSettings().update(data);
        Boolean enabled = (Boolean)data.get("enabled");
        this.channels[channel].setEnabled(Boolean.TRUE.equals(enabled));
        String name = (String)data.get("name");
        this.channels[channel].setChannelName(name);
        this.networkDirty();
        this.markDirtyQuick();
    }

    private void removeChannel(int channel) {
        this.channels[channel] = null;
        this.cachedConnectors[channel] = null;
        this.cachedRoutedConnectors[channel] = null;
        this.networkDirty();
        this.markDirtyQuick();
    }

    private void createChannel(int channel, String typeId) {
        IChannelType type = XNet.xNetApi.findType(typeId);
        this.channels[channel] = new ChannelInfo(type);
        this.networkDirty();
        this.markDirtyQuick();
    }

    private void updateConnector(int channel, SidedPos pos, Map<String, Argument> args) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        ConsumerId consumerId = worldBlob.getConsumerAt(pos.getPos().func_177972_a(pos.getSide()));
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
            SidedConsumer key = entry.getKey();
            if (!key.getConsumerId().equals(consumerId) || !key.getSide().func_176734_d().equals((Object)pos.getSide())) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Map.Entry<String, Argument> e : args.entrySet()) {
                data.put(e.getKey(), e.getValue().getValue());
            }
            this.channels[channel].getConnectors().get(key).getConnectorSettings().update(data);
            this.networkDirty();
            this.markDirtyQuick();
            return;
        }
    }

    private void removeConnector(int channel, SidedPos pos) {
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        ConsumerId consumerId = worldBlob.getConsumerAt(pos.getPos().func_177972_a(pos.getSide()));
        SidedConsumer toremove = null;
        for (Map.Entry<SidedConsumer, ConnectorInfo> entry : this.channels[channel].getConnectors().entrySet()) {
            SidedConsumer key = entry.getKey();
            if (!key.getConsumerId().equals(consumerId)) continue;
            toremove = key;
            break;
        }
        if (toremove != null) {
            this.channels[channel].getConnectors().remove(toremove);
            this.networkDirty();
            this.markDirtyQuick();
        }
    }

    private void createConnector(int channel, SidedPos pos) {
        BlockPos consumerPos;
        WorldBlob worldBlob = XNetBlobData.getBlobData(this.func_145831_w()).getWorldBlob(this.func_145831_w());
        ConsumerId consumerId = worldBlob.getConsumerAt(consumerPos = pos.getPos().func_177972_a(pos.getSide()));
        if (consumerId == null) {
            throw new RuntimeException("What?");
        }
        SidedConsumer id = new SidedConsumer(consumerId, pos.getSide().func_176734_d());
        boolean advanced = this.func_145831_w().func_180495_p(consumerPos).func_177230_c() == NetCableSetup.advancedConnectorBlock;
        this.channels[channel].createConnector(id, advanced);
        this.networkDirty();
        this.markDirtyQuick();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_CREATECHANNEL.equals(command)) {
            int index = args.get("index").getInteger();
            String typeId = args.get("type").getString();
            this.createChannel(index, typeId);
            return true;
        }
        if (CMD_CREATECONNECTOR.equals(command)) {
            int channel = args.get("channel").getInteger();
            SidedPos pos = new SidedPos(args.get("pos").getCoordinate(), EnumFacing.field_82609_l[args.get("side").getInteger()]);
            this.createConnector(channel, pos);
            return true;
        }
        if (CMD_REMOVECHANNEL.equals(command)) {
            int index = args.get("index").getInteger();
            this.removeChannel(index);
            return true;
        }
        if (CMD_REMOVECONNECTOR.equals(command)) {
            SidedPos pos = new SidedPos(args.get("pos").getCoordinate(), EnumFacing.field_82609_l[args.get("side").getInteger()]);
            int channel = args.get("channel").getInteger();
            this.removeConnector(channel, pos);
            return true;
        }
        if (CMD_UPDATECONNECTOR.equals(command)) {
            SidedPos pos = new SidedPos(args.get("pos").getCoordinate(), EnumFacing.field_82609_l[args.get("side").getInteger()]);
            int channel = args.get("channel").getInteger();
            this.updateConnector(channel, pos, args);
            return true;
        }
        if (CMD_UPDATECHANNEL.equals(command)) {
            int channel = args.get("channel").getInteger();
            this.updateChannel(channel, args);
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, Map<String, Argument> args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if (CMD_GETCHANNELS.equals(command)) {
            return type.convert(this.findChannelInfo());
        }
        if (CMD_GETCONNECTEDBLOCKS.equals(command)) {
            return type.convert(this.findConnectedBlocks());
        }
        return Collections.emptyList();
    }

    public <T> boolean execute(String command, List<T> list, Type<T> type) {
        boolean rc = super.execute(command, list, type);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_CHANNELSREADY.equals(command)) {
            GuiController.fromServer_channels = new ArrayList<ChannelClientInfo>(Type.create(ChannelClientInfo.class).convert(list));
            return true;
        }
        if (CLIENTCMD_CONNECTEDBLOCKSREADY.equals(command)) {
            GuiController.fromServer_connectedBlocks = new ArrayList<ConnectedBlockClientInfo>(Type.create(ConnectedBlockClientInfo.class).convert(list));
            return true;
        }
        return false;
    }
}

