/*
 * Decompiled with CFR 0.152.
 */
package apple_shields.items;

import apple_shields.AppleShields;
import apple_shields.confighandler.ConfigHandler;
import apple_shields.items.ItemAppleShield;
import cofh.api.energy.IEnergyContainerItem;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI")
public class ItemEnergyShield
extends ItemAppleShield
implements IEnergyContainerItem {
    public ItemEnergyShield() {
        this.func_77625_d(1);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (this.getEnergyStored(stack) > 0) {
            return EnumAction.BLOCK;
        }
        return EnumAction.NONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        super.func_150895_a(item, tab, list);
        if (AppleShields.IS_RF_PRESENT) {
            ItemStack uncharged = new ItemStack(item);
            this.extractEnergy(uncharged, this.getMaxEnergyStored(uncharged), false);
            list.add(uncharged);
        }
    }

    @Override
    public boolean damageShield(int toDamage, ItemStack stack, EntityLivingBase entity) {
        this.extractEnergy(stack, toDamage * ConfigHandler.SHIELD_ENERGY_RF_PER_DAMAGE, false);
        return true;
    }

    @Override
    public boolean repairShield(int toRepair, ItemStack stack) {
        return this.receiveEnergy(stack, toRepair, false) > 0;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int energyStored = this.getEnergyStored(container);
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energyStored, maxReceive);
        if (!simulate) {
            container.func_77964_b(this.getMaxEnergyStored(container) - (energyStored += energyReceived));
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int energyStored = this.getEnergyStored(container);
        int energyExtracted = Math.min(energyStored, maxExtract);
        if (!simulate) {
            container.func_77964_b(this.getMaxEnergyStored(container) - (energyStored -= energyExtracted));
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        return this.getMaxEnergyStored(container) - container.func_77952_i();
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getShieldType().getDurability();
    }
}

