/*
 * Decompiled with CFR 0.152.
 */
package com.jolteffect.thermalsolars.block;

import com.jolteffect.thermalsolars.ThermalSolars;
import com.jolteffect.thermalsolars.creativetabs.ThermalSolarsTabs;
import com.jolteffect.thermalsolars.init.ThermalSolarsConfig;
import com.jolteffect.thermalsolars.tile.TileEntitySolarPanel;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSolarPanel
extends Block
implements ITileEntityProvider {
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private static final int CHAT_ID = 47194716;
    private static final int GUI_ID = 2;
    private final int mTierIndex;

    public BlockSolarPanel(String pName, int pTierIndex) {
        super(Material.field_151573_f);
        this.mTierIndex = pTierIndex;
        this.field_149782_v = 5.0f;
        this.field_149762_H = SoundType.field_185852_e;
        this.func_149663_c("thermalsolars." + pName);
        this.setRegistryName("thermalsolars", pName);
        this.setHarvestLevel("pickaxe", Item.ToolMaterial.STONE.func_77996_d());
        this.func_149713_g(255);
        this.func_149647_a(ThermalSolarsTabs.tab);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySolarPanel(this.mTierIndex);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.func_175625_s(pos) == null || playerIn.func_70093_af()) {
            return false;
        }
        playerIn.openGui((Object)ThermalSolars.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? true : (blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? true : super.func_176225_a(blockState, blockAccess, pos, side));
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List<String> list, boolean par4) {
        list.add("The RF Power Generating Solar Panel");
        switch (this.mTierIndex) {
            case 1: {
                list.add("Generates: " + ThermalSolarsConfig.t1Generate + " rf/t");
                list.add("Max Transfer Rate of: " + ThermalSolarsConfig.t1MaxExtract + " rf/t");
                break;
            }
            case 2: {
                list.add("Generates: " + ThermalSolarsConfig.t2Generate + " rf/t");
                list.add("Max Transfer Rate of: " + ThermalSolarsConfig.t2MaxExtract + " rf/t");
                break;
            }
            case 3: {
                list.add("Generates: " + ThermalSolarsConfig.t3Generate + " rf/t");
                list.add("Max Transfer Rate of: " + ThermalSolarsConfig.t3MaxExtract + " rf/t");
                break;
            }
            case 4: {
                list.add("Generates: " + ThermalSolarsConfig.t4Generate + " rf/t");
                list.add("Max Transfer Rate of: " + ThermalSolarsConfig.t4MaxExtract + " rf/t");
                break;
            }
            case 5: {
                list.add("Generates: " + ThermalSolarsConfig.t5Generate + " rf/t");
                list.add("Max Transfer Rate of: " + ThermalSolarsConfig.t5MaxExtract + " rf/t");
                break;
            }
            case 6: {
                list.add("Generates: " + ThermalSolarsConfig.t6Generate + " rf/t");
                list.add("Max Transfer Rate of: " + ThermalSolarsConfig.t6MaxExtract + " rf/t");
                break;
            }
            case 101: {
                list.add("Generates: " + ThermalSolarsConfig.t1lunarGenerate + " rf/t");
                list.add("Max Transfer Rate of: " + ThermalSolarsConfig.t1lunarMaxExtract + " rf/t");
                break;
            }
            case 102: {
                list.add("Generates: " + ThermalSolarsConfig.t2lunarGenerate + " rf/t");
                list.add("Max Transfer Rate of: " + ThermalSolarsConfig.t2lunarMaxExtract + " rf/t");
                break;
            }
            case 103: {
                list.add("Generates: " + ThermalSolarsConfig.t3lunarGenerate + " rf/t");
                list.add("Max Transfer Rate of: " + ThermalSolarsConfig.t3lunarMaxExtract + " rf/t");
                break;
            }
            default: {
                list.add("Generates: " + ThermalSolarsConfig.t1Generate + " rf/t");
                list.add("Max Transfer Rate of: " + ThermalSolarsConfig.t1MaxExtract + " rf/t");
            }
        }
    }
}

