/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.shared;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.common.versioning.VersionRange;

public class FoamFixConfig {
    public boolean isVanillaLaunchwrapper;
    public boolean lwWeakenResourceCache;
    public boolean clDeduplicate;
    public boolean clCleanRedundantModelRegistry;
    public boolean clDynamicItemModels;
    public boolean clFasterVertexLighter;
    public boolean clInitOptions;
    public boolean clParallelModelBaking;
    public boolean clDisableTextureAnimations;
    public boolean geBlacklistLibraryTransformers;
    public boolean geBlockPosPatch;
    public boolean geFasterEntityLookup;
    public boolean geFasterPropertyComparisons;
    public boolean geFasterAirLookup;
    public boolean geDynamicRegistrySizeScaling;
    public boolean twDisableRedstoneLight;
    public boolean geSmallPropertyStorage;
    public boolean gePatchChunkSerialization;
    public boolean twImmediateLightingUpdates;
    public boolean geReplaceSimpleName;
    public boolean geFasterCollisionBoxes;
    public int clDeduplicateRecursionLevel;
    private final Set<Property> applicableProperties = Sets.newIdentityHashSet();
    private Configuration config;
    private boolean isCoremod;
    public boolean geSmallLightingOptimize = false;

    private boolean getBoolean(String name, String category, boolean defaultValue, String description, boolean requiresRestart, boolean showInGui) {
        Property prop = this.config.get(category, name, defaultValue);
        prop.setDefaultValue(defaultValue);
        prop.setComment(description + " [default: " + defaultValue + "]");
        prop.setRequiresMcRestart(requiresRestart);
        prop.setShowInGui(showInGui);
        prop.setLanguageKey("foamfix.config." + name);
        this.applicableProperties.add(prop);
        return prop.getBoolean(defaultValue);
    }

    private int getInt(String name, String category, int defaultValue, int minValue, int maxValue, String comment, boolean requiresRestart, boolean showInGui) {
        Property prop = this.config.get(category, name, defaultValue);
        prop.setMinValue(minValue);
        prop.setMaxValue(maxValue);
        prop.setComment(comment + " [default: " + defaultValue + ", range: " + minValue + "-" + maxValue + "]");
        prop.setRequiresMcRestart(requiresRestart);
        prop.setShowInGui(showInGui);
        prop.setLanguageKey("foamfix.config." + name);
        this.applicableProperties.add(prop);
        return prop.getInt(defaultValue);
    }

    private boolean getBoolean(String name, String category, boolean defaultValue, String description, boolean requiresRestart, boolean showInGui, String forgeVersionRange) {
        VersionRange range = VersionParser.parseRange((String)forgeVersionRange);
        DefaultArtifactVersion requiredVersion = new DefaultArtifactVersion("Forge", range);
        if (requiredVersion.containsVersion((ArtifactVersion)new DefaultArtifactVersion("Forge", ForgeVersion.getVersion()))) {
            return this.getBoolean(name, category, defaultValue, description, requiresRestart, showInGui);
        }
        return false;
    }

    public void reload() {
        boolean bl = this.isVanillaLaunchwrapper = this.getClass().getClassLoader() instanceof LaunchClassLoader && !this.getClass().getClassLoader().getClass().getName().startsWith("fastcraft");
        if (this.isVanillaLaunchwrapper) {
            this.lwWeakenResourceCache = this.getBoolean("weakenResourceCache", "launchwrapper", true, "Weaken LaunchWrapper's byte[] resource cache to make it cleanuppable by the GC. Safe.", true, true);
        }
        this.clDeduplicate = this.getBoolean("deduplicateModels", "client", true, "Enable deduplication of redundant objects in memory.", true, true);
        this.clDeduplicateRecursionLevel = this.getInt("deduplicateModelsMaxRecursion", "client", 6, 1, Integer.MAX_VALUE, "The maximum amount of levels of recursion for the deduplication process. Smaller values will deduplicate less data, but make the process run faster.", true, true);
        this.clCleanRedundantModelRegistry = this.getBoolean("clearDuplicateModelRegistry", "client", true, "Clears the baked models generated in the first pass *before* entering the second pass, instead of *after*. While this doesn't reduce memory usage in-game, it does reduce it noticeably during loading.", true, true);
        this.geDynamicRegistrySizeScaling = this.getBoolean("dynamicRegistrySizeScaling", "general", true, "Makes large FML registries scale their availability BitSets dynamically, saving ~48MB of RAM.", true, true, "(,13.19.1.2190)");
        if (this.isCoremod) {
            if (this.isVanillaLaunchwrapper) {
                this.geBlacklistLibraryTransformers = this.getBoolean("blacklistLibraryTransformers", "coremod", true, "Stops certain non-Minecraft-related libraries from being ASM transformed. You shouldn't be transforming those anyway.", true, true);
            }
            this.gePatchChunkSerialization = this.getBoolean("patchChunkSerialization", "general", true, "Fix a bug in chunk serialization leading to crashes. Originally found and fixed by Aaron1011 of Sponge.", true, true);
            this.clDisableTextureAnimations = this.getBoolean("disableTextureAnimations", "client", false, "Disables texture animations.", false, true);
            this.clInitOptions = this.getBoolean("initOptions", "client", true, "Initialize the options.txt and forge.cfg files with rendering performance-friendly defaults if not present.", true, false);
            this.clFasterVertexLighter = this.getBoolean("fasterVertexLighter", "experimental", true, "Implements optimizations to VertexLighter(Flat) inspired by thecodewarrior and bs2609's work.", true, true);
            this.twImmediateLightingUpdates = this.getBoolean("immediateLightingUpdates", "tweaks", false, "Do not delay lighting updates over other types of updates.", true, true);
            this.geSmallPropertyStorage = this.getBoolean("smallPropertyStorage", "coremod", true, "Replaces the default BlockState/ExtendedBlockState implementations with a far more memory-efficient variant.", true, true);
            this.geBlockPosPatch = this.getBoolean("optimizedBlockPos", "coremod", true, "Optimizes BlockPos mutable/immutable getters to run on the same variables, letting them be inlined and thus theoretically increasing performance.", true, true);
            this.clDynamicItemModels = this.getBoolean("dynamicItemModels", "coremod", true, "Make 3D forms of items be rendered dynamically and cached when necessary.", true, true);
            this.clParallelModelBaking = this.getBoolean("parallelModelBaking", "experimental", true, "Threaded, parallel model baking.", true, true);
            this.geReplaceSimpleName = this.getBoolean("replaceWorldSimpleName", "coremod", true, "Replaces Class.getSimpleName in World.updateEntities with getName. As Class.getName's output is cached, unlike getSimpleName, this should provide a small performance boost.", true, true);
            this.geFasterEntityLookup = this.getBoolean("fasterEntityLookup", "coremod", true, "Speeds up entity lookup by optimizing ClassInheritanceMultiMap.getByClass.", true, true);
            this.geFasterAirLookup = this.getBoolean("fasterAirItemLookup", "coremod", true, "Optimizes ItemStack.isEmpty by removing a map lookup.", true, true);
            this.geFasterPropertyComparisons = this.getBoolean("fasterPropertyComparisons", "coremod", true, "Optimizes blockstate property equals and hashCode methods.", true, true);
            this.geFasterCollisionBoxes = this.getBoolean("fasterCollisionBoxes", "coremod", true, "Speeds up World.getCollisionBoxes by being clever with when events are called.", true, true);
        }
        this.twDisableRedstoneLight = this.getBoolean("disableRedstoneLight", "tweaks", false, "Prevent redstone from causing light updates by removing its light level.", true, true);
        this.config.save();
    }

    public void init(File file, boolean isCoremod) {
        if (this.config == null) {
            this.config = new Configuration(file);
            this.isCoremod = isCoremod;
            this.reload();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public boolean isApplicable(Property property) {
        return this.applicableProperties.contains(property);
    }

    public Property getProperty(String name, String category) {
        ConfigCategory cat = this.config.getCategory(category);
        if (cat != null && cat.containsKey(name)) {
            return cat.get(name);
        }
        return null;
    }
}

