/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.common;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pl.asie.foamfix.common.FoamyBlockState;
import pl.asie.foamfix.common.PropertyValueMapper;

public class FoamyExtendedBlockState
extends FoamyBlockState
implements IExtendedBlockState {
    private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;
    private final boolean hasUnlistedProperty;

    public FoamyExtendedBlockState(PropertyValueMapper owner, Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, boolean hasUnlistedProperty) {
        super(owner, block, properties);
        this.unlistedProperties = unlistedProperties;
        this.hasUnlistedProperty = hasUnlistedProperty;
    }

    public FoamyExtendedBlockState(PropertyValueMapper owner, Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, boolean hasUnlistedProperty, int value) {
        super(owner, block, properties);
        this.unlistedProperties = unlistedProperties;
        this.hasUnlistedProperty = hasUnlistedProperty;
        this.value = value;
    }

    @Override
    public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(IProperty<T> property, V propertyValue) {
        int newValue = this.owner.withPropertyValue(this.value, property, propertyValue);
        if (newValue == this.value) {
            return this;
        }
        if (newValue < 0) {
            if (!this.func_177228_b().containsKey(property)) {
                throw new IllegalArgumentException("Cannot set property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
            }
            if (!property.func_177700_c().contains(propertyValue)) {
                throw new IllegalArgumentException("Cannot set property " + property + " to " + this.value + " on block " + Block.field_149771_c.func_177774_c((Object)this.func_177230_c()) + ", it is not an allowed value");
            }
            throw new IllegalArgumentException("Cannot set property " + property + " because FoamFix could not find a mapping for it! Please reproduce without FoamFix first!");
        }
        IBlockState state = this.owner.getPropertyByValue(newValue);
        if (state == null) {
            throw new IllegalArgumentException("Incomplete? list of values when trying to set property " + property + "! Please reproduce without FoamFix first! (Info: " + this.func_177230_c().getRegistryName() + " " + this.value + " -> " + newValue + ")");
        }
        if (this.hasUnlistedProperty) {
            return new FoamyExtendedBlockState(this.owner, this.func_177230_c(), state.func_177228_b(), this.unlistedProperties, true, newValue);
        }
        return state;
    }

    public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, V value) {
        if (!property.isValid(value)) {
            throw new IllegalArgumentException("Cannot set unlisted property " + property + " to " + value + " on block " + Block.field_149771_c.func_177774_c((Object)this.func_177230_c()) + ", it is not an allowed value");
        }
        boolean hasOpt = false;
        boolean setValue = false;
        ImmutableMap.Builder newMap = new ImmutableMap.Builder();
        for (Map.Entry entry : this.unlistedProperties.entrySet()) {
            IUnlistedProperty entryKey = (IUnlistedProperty)entry.getKey();
            if (!setValue && entryKey.equals(property)) {
                newMap.put((Object)entryKey, (Object)Optional.fromNullable(value));
                setValue = true;
                continue;
            }
            Optional entryValue = (Optional)entry.getValue();
            newMap.put((Object)entryKey, (Object)entryValue);
            hasOpt |= entryValue.isPresent();
        }
        if (!setValue) {
            throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
        }
        if (value != null || hasOpt) {
            return new FoamyExtendedBlockState(this.owner, this.func_177230_c(), this.func_177228_b(), newMap.build(), true, this.value);
        }
        return (IExtendedBlockState)this.owner.getPropertyByValue(this.value);
    }

    public Collection<IUnlistedProperty<?>> getUnlistedNames() {
        return this.unlistedProperties.keySet();
    }

    public <V> V getValue(IUnlistedProperty<V> property) {
        Optional optional = (Optional)this.unlistedProperties.get(property);
        if (optional == null) {
            throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
        }
        return (V)property.getType().cast(optional.orNull());
    }

    public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
        return this.unlistedProperties;
    }

    public IBlockState getClean() {
        return this.owner.getPropertyByValue(this.value);
    }
}

