/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.wired.Util;

import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ColorUtil {
    public static Color getColor(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        for (Color color : Color.VALUES) {
            int colorID = OreDictionary.getOreID((String)color.dyeName);
            for (int oreID : oreIDs) {
                if (colorID != oreID) continue;
                return color;
            }
        }
        return null;
    }

    public static int getRandomColor() {
        int color = (int)(Math.random() * 16.0);
        return Color.VALUES[color].color;
    }

    public static enum Color {
        Black(0x444444, "dyeBlack"),
        Red(11743532, "dyeRed"),
        Green(0x339911, "dyeGreen"),
        Brown(5320730, "dyeBrown"),
        Blue(0x6666FF, "dyeBlue"),
        Purple(8073150, "dyePurple"),
        Cyan(0x66FFFF, "dyeCyan"),
        LightGray(0xABABAB, "dyeLightGray"),
        Gray(0x666666, "dyeGray"),
        Pink(14188952, "dyePink"),
        Lime(0x66FF66, "dyeLime"),
        Yellow(0xFFFF66, "dyeYellow"),
        LightBlue(0xAAAAFF, "dyeLightBlue"),
        Magenta(12801229, "dyeMagenta"),
        Orange(15435844, "dyeOrange"),
        White(0xFFFFFF, "dyeWhite");

        public static final Color[] VALUES;
        private final int color;
        private final String dyeName;

        private Color(int color, String dyeName) {
            this.color = color;
            this.dyeName = dyeName;
        }

        public int ColorAsInt() {
            return this.color;
        }

        public String ColorAsOreTag() {
            return this.dyeName;
        }

        static {
            VALUES = Color.values();
        }
    }
}

