/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.wired.Handler;

import com.mr208.wired.Common.Entity.EntityCyberSkeleton;
import com.mr208.wired.Common.Entity.EntityGreyGoo;
import com.mr208.wired.Common.Entity.ICyberEntity;
import com.mr208.wired.Common.Item.Equipment.ItemWiredArmor;
import com.mr208.wired.Common.Item.WiredItems;
import com.mr208.wired.Handler.ConfigHandler;
import com.mr208.wired.Handler.Events.EventAugBlockInteract;
import com.mr208.wired.Handler.Events.EventAugDeath;
import com.mr208.wired.Handler.Events.EventAugEntityInteract;
import com.mr208.wired.Util.ColorUtil;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.tile.TileEntityBeacon;
import flaxbeard.cyberware.common.handler.CyberwareDataHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventsHandler {
    public static float GREY_GOO_SPAWN_CHANCE = ConfigHandler.CyberMobs.GreyGoo.SPAWN_CHANCE / 100.0f;
    public static final EventsHandler INSTANCE = new EventsHandler();

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        EnumHand enumHand = event.getHand();
        Entity entityTarget = event.getTarget();
        if (CyberwareAPI.hasCapability((Entity)entityPlayer)) {
            EventAugEntityInteract eventAugEntityInteract = new EventAugEntityInteract(entityPlayer, entityTarget, enumHand);
            MinecraftForge.EVENT_BUS.post((Event)eventAugEntityInteract);
        }
    }

    @SubscribeEvent
    public void onCyberwareDeath(LivingDeathEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (ConfigHandler.CyberMobs.GreyGoo.ENABLED && CyberwareAPI.hasCapability((Entity)entityLivingBase)) {
            EventAugDeath eventAugDeath = new EventAugDeath(entityLivingBase);
            MinecraftForge.EVENT_BUS.post((Event)eventAugDeath);
        }
    }

    @SubscribeEvent
    public void onAugmentedDeath(EventAugDeath event) {
        EntityLivingBase deadEntity = event.getEntityLivingBase();
        if (deadEntity.field_70170_p.field_72995_K) {
            return;
        }
        if (!(deadEntity instanceof EntityGreyGoo) && deadEntity.field_70170_p.field_73012_v.nextFloat() < GREY_GOO_SPAWN_CHANCE) {
            EntityGreyGoo greyGoo = new EntityGreyGoo(deadEntity.field_70170_p);
            greyGoo.func_70012_b(deadEntity.field_70165_t, deadEntity.field_70163_u, deadEntity.field_70161_v, deadEntity.field_70177_z, deadEntity.field_70125_A);
            deadEntity.field_70170_p.func_72838_d((Entity)greyGoo);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (CyberwareAPI.hasCapability((Entity)entityLivingBase)) {
            EventAugBlockInteract eventAugBlockInteract = new EventAugBlockInteract(entityLivingBase, event.getPos(), event.getFace(), event.getHand());
            MinecraftForge.EVENT_BUS.post((Event)eventAugBlockInteract);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleCyberSkeletonSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntityLiving() instanceof EntitySkeleton && !(event.getEntityLiving() instanceof EntityCyberSkeleton)) {
            EntitySkeleton skeleton = (EntitySkeleton)event.getEntityLiving();
            int tier = TileEntityBeacon.isInRange((World)skeleton.field_70170_p, (double)skeleton.field_70165_t, (double)skeleton.field_70163_u, (double)skeleton.field_70161_v);
            if (tier > 0) {
                float chance;
                float f = tier == 2 ? 10.0f : (chance = tier == 1 ? 5.0f : 20.0f);
                if (!ConfigHandler.CyberMobs.CyberSkeleton.ENABLED || !(event.getWorld().field_73012_v.nextFloat() < chance / 100.0f)) {
                    return;
                }
                EntityCyberSkeleton cyberSkeleton = new EntityCyberSkeleton(event.getWorld());
                cyberSkeleton.func_70012_b(skeleton.field_70165_t, skeleton.field_70163_u, skeleton.field_70161_v, skeleton.field_70177_z, skeleton.field_70125_A);
                for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                    cyberSkeleton.func_184201_a(slot, skeleton.func_184582_a(slot));
                }
                event.getWorld().func_72838_d((Entity)cyberSkeleton);
                skeleton.field_70725_aQ = 19;
                skeleton.func_70606_j(0.0f);
                float chestRand = cyberSkeleton.field_70170_p.field_73012_v.nextFloat();
                if (!cyberSkeleton.field_70170_p.field_72995_K && skeleton.func_184582_a(EntityEquipmentSlot.CHEST) == null && chestRand < 0.04f) {
                    ItemStack stack = new ItemStack((Item)CyberwareContent.trenchcoat);
                    int rand = skeleton.field_70170_p.field_73012_v.nextInt(3);
                    if (rand == 0) {
                        CyberwareContent.trenchcoat.func_82813_b(stack, 6701096);
                    } else if (rand == 1) {
                        CyberwareContent.trenchcoat.func_82813_b(stack, 0xEAEAEA);
                    }
                    skeleton.func_184201_a(EntityEquipmentSlot.CHEST, stack);
                    skeleton.func_184642_a(EntityEquipmentSlot.CHEST, 0.3f);
                }
            }
        }
    }

    public static void addRandomCyberware(ICyberEntity entity) {
        ICyberwareUserData data = CyberwareAPI.getCapability((Entity)((EntityLivingBase)entity));
        ArrayList<ArrayList<ItemStack>> wares = new ArrayList<ArrayList<ItemStack>>();
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>(Arrays.asList(data.getInstalledCyberware(slot)));
            toAdd.removeAll(Collections.singleton(null));
            wares.add(toAdd);
        }
        ItemStack battery = new ItemStack((Item)CyberwareContent.creativeBattery);
        ((List)wares.get(CyberwareContent.creativeBattery.getSlot(battery).ordinal())).add(battery);
        int numberOfItemsToInstall = ((CyberwareContent.NumItems)WeightedRandom.func_76271_a((Random)((EntityLivingBase)entity).field_70170_p.field_73012_v, (List)CyberwareContent.numItems)).num;
        ArrayList<ItemStack> installed = new ArrayList<ItemStack>();
        ArrayList items = new ArrayList(CyberwareContent.zombieItems);
        for (int i = 0; i < numberOfItemsToInstall; ++i) {
            ItemStack[][] required;
            int tries = 0;
            ItemStack randomItem = null;
            ICyberware randomWare = null;
            do {
                randomItem = ItemStack.func_77944_b((ItemStack)((CyberwareContent.ZombieItem)WeightedRandom.func_76271_a((Random)((EntityLivingBase)entity).field_70170_p.field_73012_v, items)).stack);
                randomWare = CyberwareAPI.getCyberware((ItemStack)randomItem);
                randomItem.field_77994_a = randomWare.installedStackSize(randomItem);
            } while (CyberwareDataHandler.contains((List)((List)wares.get(randomWare.getSlot(randomItem).ordinal())), (ItemStack)randomItem) && ++tries < 10);
            if (tries >= 10) continue;
            for (ItemStack[] requiredCategory : required = (ItemStack[][])randomWare.required(randomItem).clone()) {
                boolean found = false;
                int n = 0;
                ItemStack[] itemStackArray = requiredCategory;
                int n2 = itemStackArray.length;
                if (n < n2) {
                    ItemStack option = itemStackArray[n];
                    ICyberware optionWare = CyberwareAPI.getCyberware((ItemStack)option);
                    option.field_77994_a = optionWare.installedStackSize(option);
                    if (CyberwareDataHandler.contains((List)((List)wares.get(optionWare.getSlot(option).ordinal())), (ItemStack)option)) {
                        // empty if block
                    }
                    found = true;
                }
                if (found) continue;
                ItemStack req = requiredCategory[((EntityLivingBase)entity).field_70170_p.field_73012_v.nextInt(requiredCategory.length)].func_77946_l();
                ICyberware reqWare = CyberwareAPI.getCyberware((ItemStack)req);
                req.field_77994_a = reqWare.installedStackSize(req);
                ((List)wares.get(reqWare.getSlot(req).ordinal())).add(req);
                installed.add(req);
                ++i;
            }
            ((List)wares.get(randomWare.getSlot(randomItem).ordinal())).add(randomItem);
            installed.add(randomItem);
        }
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            data.setInstalledCyberware((EntityLivingBase)entity, slot, (List)wares.get(slot.ordinal()));
        }
        data.updateCapacity();
        ((EntityLivingBase)entity).func_70606_j(((EntityLivingBase)entity).func_110138_aP());
        entity.setHasWare(true);
        CyberwareAPI.updateData((Entity)((EntityLivingBase)entity));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void CyberSpawnEvent(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if ((event.getEntityLiving() instanceof EntityZombie || event.getEntityLiving() instanceof ICyberEntity || event.getEntityLiving() instanceof EntitySkeleton) && !(event.getEntityLiving() instanceof EntityPigZombie) && !(event.getEntityLiving() instanceof EntityGreyGoo)) {
            EntityLiving entityLiving = (EntityLiving)event.getEntityLiving();
            if (ConfigHandler.Equipment.TechVisor.ENABLED && entityLiving.func_184582_a(EntityEquipmentSlot.HEAD) == null && entityLiving.field_70170_p.field_73012_v.nextFloat() < ConfigHandler.Equipment.TechVisor.SPAWN_CHANCE / 100.0f) {
                ItemStack visorItemStack = new ItemStack((Item)WiredItems.helmetTechVisor);
                ((ItemWiredArmor)visorItemStack.func_77973_b()).func_82813_b(visorItemStack, ColorUtil.getRandomColor());
                entityLiving.func_184201_a(EntityEquipmentSlot.HEAD, visorItemStack);
                entityLiving.func_184642_a(EntityEquipmentSlot.HEAD, ConfigHandler.Equipment.TechVisor.DROP_CHANCE / 100.0f);
            }
            if (ConfigHandler.Equipment.Clothing.ENABLED && entityLiving.func_184582_a(EntityEquipmentSlot.LEGS) == null && entityLiving.field_70170_p.field_73012_v.nextFloat() < ConfigHandler.Equipment.Clothing.SPAWN_CHANCE / 100.0f) {
                ItemStack pantsItemStack = new ItemStack((Item)WiredItems.pantsCamo);
                ((ItemWiredArmor)pantsItemStack.func_77973_b()).func_82813_b(pantsItemStack, ColorUtil.getRandomColor());
                entityLiving.func_184201_a(EntityEquipmentSlot.LEGS, pantsItemStack);
                entityLiving.func_184642_a(EntityEquipmentSlot.LEGS, ConfigHandler.Equipment.Clothing.DROP_CHANCE / 100.0f);
            }
            if (ConfigHandler.Equipment.Shields.ENABLED && entityLiving.func_184582_a(EntityEquipmentSlot.OFFHAND) == null && !(entityLiving instanceof EntitySkeleton) && entityLiving.field_70170_p.field_73012_v.nextFloat() < ConfigHandler.Equipment.Shields.SPAWN_CHANCE / 100.0f) {
                ItemStack plexiItemStack = new ItemStack((Item)WiredItems.shieldRiot);
                entityLiving.func_184201_a(EntityEquipmentSlot.OFFHAND, plexiItemStack);
                entityLiving.func_184642_a(EntityEquipmentSlot.OFFHAND, ConfigHandler.Equipment.Shields.DROP_CHANCE / 100.0f);
            }
        }
    }

    @SubscribeEvent
    public void addLootToTables(LootTableLoadEvent event) {
        if (event.getName() == LootTableList.field_186429_k || event.getName() == LootTableList.field_186430_l || event.getName() == LootTableList.field_186422_d || event.getName() == LootTableList.field_186424_f) {
            LootTable lootTable = event.getTable();
            LootPool lootPool = event.getTable().getPool("main");
            if (lootPool != null) {
                LootCondition[] lootConditions = new LootCondition[]{};
                LootFunction[] lootFunctionsSingle = new LootFunction[]{new SetCount(lootConditions, new RandomValueRange(0.0f, 1.0f))};
                LootFunction[] lootFunctions = new LootFunction[]{new SetCount(lootConditions, new RandomValueRange(1.0f, 5.0f))};
                if (ConfigHandler.Cyberstomach.CyborgFood.SilverGorgon.canBeLoot()) {
                    lootPool.addEntry((LootEntry)new LootEntryItem((Item)WiredItems.foodEnergyDrink, 15, 0, lootFunctions, lootConditions, "wired:energydrink"));
                }
                if (ConfigHandler.Cyberstomach.CyborgFood.PowerBar.canBeLoot()) {
                    lootPool.addEntry((LootEntry)new LootEntryItem((Item)WiredItems.foodPowerBar, 15, 0, lootFunctions, lootConditions, "wired:powerbar"));
                }
                if (ConfigHandler.Equipment.Shields.canBeLoot()) {
                    lootPool.addEntry((LootEntry)new LootEntryItem((Item)WiredItems.shieldRiot, 10, 0, lootFunctionsSingle, lootConditions, "wired:shieldRiot"));
                    lootPool.addEntry((LootEntry)new LootEntryItem((Item)WiredItems.shieldReinforced, 10, 0, lootFunctionsSingle, lootConditions, "wired:shieldReinforced"));
                    lootPool.addEntry((LootEntry)new LootEntryItem((Item)WiredItems.shieldAlloyed, 10, 0, lootFunctionsSingle, lootConditions, "wired:shieldAlloyed"));
                }
                if (ConfigHandler.Equipment.Batons.canBeLoot()) {
                    lootPool.addEntry((LootEntry)new LootEntryItem((Item)WiredItems.batonShock, 1, 0, lootFunctionsSingle, lootConditions, "wired:baton.shock"));
                }
            }
        }
    }
}

